% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app.R
\name{best_ranked_internal_metrics}
\alias{best_ranked_internal_metrics}
\title{Best rated internal metrics.}
\usage{
best_ranked_internal_metrics(df)
}
\arguments{
\item{df}{matrix or data frame with the result of running the clustering algorithm.}
}
\value{
Returns a data.frame with the best classified internal attributes.
}
\description{
method in charge of searching for each algorithm those that have the best internal classification.

Method that looks for those internal attributes that are better classified,
making use of the ranking column. In this way we discard the rest of the attributes and
only work with those that give the best response to the algorithm in question.
}
\examples{

result = clustering(
               df = cluster::agriculture,
               min = 4,
               max = 5,
               algorithm='gmm',
               metrics=c("recall"),
               attributes = FALSE
         )

best_ranked_internal_metrics(df = result)

\dontrun{
best_ranked_internal_metrics(df = result$result)
}

}
