% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_functions.R
\name{distance_matrix}
\alias{distance_matrix}
\title{Distance matrix calculation}
\usage{
distance_matrix(data, method = "euclidean", upper = FALSE,
  diagonal = FALSE, minkowski_p = 1, threads = 1)
}
\arguments{
\item{data}{matrix or data frame}

\item{method}{a string specifying the distance method. One of,  \emph{euclidean},  \emph{manhattan},  \emph{chebyshev},  \emph{canberra},  \emph{braycurtis},  \emph{pearson_correlation},  \emph{simple_matching_coefficient},  \emph{minkowski},  \emph{hamming},  \emph{jaccard_coefficient},  \emph{Rao_coefficient},  \emph{mahalanobis}}

\item{upper}{either TRUE or FALSE specifying if the upper triangle of the distance matrix should be returned. If FALSE then the upper triangle will be filled with NA's}

\item{diagonal}{either TRUE or FALSE specifying if the diagonal of the distance matrix should be returned. If FALSE then the diagonal will be filled with NA's}

\item{minkowski_p}{a numeric value specifying the minkowski parameter in case that method = "minkowski"}

\item{threads}{the number of cores to run in parallel (if OpenMP is available)}
}
\value{
a matrix
}
\description{
Distance matrix calculation
}
\examples{

data(dietary_survey_IBS)

dat = dietary_survey_IBS[, -ncol(dietary_survey_IBS)]

dat = distance_matrix(dat, method = 'euclidean', upper = TRUE, diagonal = TRUE)

}

