#' @export print.hclustgeo.uniq
#' @name print.hclustgeo.uniq
#' @method print hclustgeo.uniq
#' @S3method print hclustgeo.uniq
#' @title Print a 'hclustgeo.uniq' object
#' @description This is a method for the function print for objects of the class \code{hclustgeo.uniq}.
#' @param x an object of class  \code{hclustgeo.uniq} generated by the function \code{hclustgeo.uniq}
#' @param \dots  further arguments to be passed to or from other methods. They are ignored in this function.
#' @keywords internal

print.hclustgeo.uniq <- function(x, ...){
  if (!inherits(x, "hclustgeo.uniq")) 
    stop("use only with \"hclustgeo.uniq\" objects")
  
  cat("Method = hclustgeo.uniq")
  cat("\n")
  cat("\nCall:\n", deparse(x$call), "\n\n", sep = "")
  
  #res <- matrix("",8,2)
  res <- matrix("",5,2)
  
  colnames(res) <-c("name","description")
  #res[1,] <- c("$merge", "object used in class 'hclust'")
  #res[2,] <- c("$height", "object used in class 'hclust'")
  #res[3,] <- c("$order", "object used in class 'hclust'")
  res[1,] <- c("$alpha", "parameter 'alpha' used in the method")
  res[2,] <- c("$dist.var", "The no-scaled matrix of distance calculated on 'data' ")  
  res[3,] <- c("$dist.geo", "The no-scaled matrix of geographical distance ")   
  res[4,] <- c("$wt", "weights of individuals")    
  res[5,] <- c("$data", "data matrix describing individuals used in the method")    
  
  print(res)
}