% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cluscata.R
\name{plot.cluscata}
\alias{plot.cluscata}
\title{Displays the CLUSCATA graphs}
\usage{
\method{plot}{cluscata}(x, ngroups=NULL, Graph_groups=TRUE, Graph_dend=TRUE,
Graph_bar=FALSE, Graph_weights=FALSE, axes=c(1,2), cex=1,
col.obj="blue", col.attr="red", ...)
}
\arguments{
\item{x}{object of class 'cluscata'.}

\item{ngroups}{number of groups to consider. Ignored for cluscata_kmeans results. Default: recommended  number of clusters}

\item{Graph_groups}{logical. Should each cluster compromise graphical representation be plotted? Default: TRUE}

\item{Graph_dend}{logical. Should the dendrogram be plotted? Default: TRUE}

\item{Graph_bar}{logical. Should the barplot of the difference of the criterion and the barplot of the overall homogeneity at each merging step of the hierarchical algorithm be plotted? Also available after consolidation if Noise_cluster=FALSE. Default: FALSE}

\item{Graph_weights}{logical. Should the barplot of the weights in each cluster be plotted? Default: FALSE}

\item{axes}{numerical vector (length 2). Axes to be ploted. Default: c(1,2)}

\item{cex}{numerical. Numeric character expansion factor; multiplied by par("cex") yields the final character size. NULL and NA are equivalent to 1.0.}

\item{col.obj}{numerical or string. Color for the objects points. Default: "blue"}

\item{col.attr}{numerical or string. Color for the attributes points. Default: "red"}

\item{...}{further arguments passed to or from other methods}
}
\value{
the CLUSCATA graphs
}
\description{
This function plots dendrogram, variation of the merging criterion, weights and CATATIS map of each cluster
}
\examples{
\dontrun{
 data(straw)
 res=cluscata(Data=straw[,1:(16*40)], nblo=40)
 plot(res, ngroups=3, Graph_dend=FALSE)
 plot(res, ngroups=3, Graph_dend=FALSE,Graph_bar=FALSE, Graph_weights=FALSE, axes=c(1,3))
}
}
\seealso{
\code{\link{cluscata}} , \code{\link{cluscata_kmeans}}
}
\keyword{CATA}
