% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusvisvarsellcm.R
\name{clusvisVarSelLCM}
\alias{clusvisVarSelLCM}
\title{This function estimates the parameters used for visualization of model-based clustering performs with R package Rmixmod. To achieve the parameter infernece, it automatically samples probabilities of classification from the model parameters}
\usage{
clusvisVarSelLCM(varselResult, sample.size = 5000, maxit = 10^3,
  nbrandomInit = 4 * varselResult@model@g, nbcpu = 1, loccont = NULL)
}
\arguments{
\item{varselResult}{[\code{\linkS4class{VSLCMresults}}] It is an instance of class VSLCMresults returned by function VarSelCluster of R package VarSelLCM.}

\item{sample.size}{numeric. Number of probabilities of classification sampled for parameter inference.}

\item{maxit}{numeric. It limits the number of iterations for the Quasi-Newton algorithm (default 1000).}

\item{nbrandomInit}{numeric. It defines the number of random initialization of the Quasi-Newton algorithm.}

\item{nbcpu}{numeric. It specifies the number of CPU (only for linux).}

\item{loccont}{numeric. Index of the column containing continuous variables (only for mixed-type data).}
}
\value{
Returns a list
}
\description{
This function estimates the parameters used for visualization of model-based clustering performs with R package Rmixmod. To achieve the parameter infernece, it automatically samples probabilities of classification from the model parameters
}
\examples{
\dontrun{

 # Package loading
 require(VarSelLCM)

 # Data loading (categorical data)
 data("congress")
 # Model-based clustering with 3 components
 res <- VarSelCluster(congress, 3)

 # Inference of the parameters used for results visualization
 # (specific for Rmixmod results)
 # It is better because probabilities of classification are generated
 # by using the model parameters
 resvisu <- clusvisVarSelLCM(res)

 # Component interpretation graph
 plotDensityClusVisu(resvisu)

 # Scatter-plot of the observation memberships
 plotDensityClusVisu(resvisu,  add.obs = TRUE)

}
}
