% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TCFs.R
\name{TCFs}
\alias{TCFs}
\title{Estimation of the covariate-specific TCFs for clustered data.}
\usage{
TCFs(out_lme2, newdata, thresholds, apVar = FALSE)
}
\arguments{
\item{out_lme2}{an object of class "lme2", a result of \code{\link{lme2}} call.}

\item{newdata}{a data frame (containing specific value(s) of covariate(s)) in which to look for variables with which to estimate covariate-specific TCFs. In absence of covariate, no values have to be specified.}

\item{thresholds}{specified pair of thresholds.}

\item{apVar}{logical value. If set to \code{TRUE}, the variance-covariance matrix of estimated covariate-specific TCFs is estimated.}
}
\value{
\code{TCFs} returns an object of class "TCFs", which is a list containing at least the following components:

\item{call}{the matched call.}
\item{tcfs_est}{a vector or matrix containing the estimated TCFs.}
\item{tcf_vcov}{a matrix or list of matrices containing the estimated variance-covariance matrices.}
\item{thresholds}{specified pair of thresholds.}
\item{mess_order}{a diagnostic message from checking the monontone ordering.}
\item{newdata}{value(s) of covariate(s).}
\item{n_p}{total number of regressors in the model.}

Generic functions such as \code{print} is also used to show the results.
}
\description{
\code{TCFs} estimates covariate-specific True Class Fractions (TCFs), at a specified pair of thresholds, of a continuous diagnostic test in a clustered design with three ordinal groups. This function allows to estimate covariate-specific TCFs at multiple points for covariates.
}
\details{
This function implements a method in To et al. (2022) for estimating covariate-specific TCFs at a specified pair of thresholds of a continuous diagnostic test in a clustered design with three ordinal groups. The estimator is based on results from  \code{\link{lme2}}, which uses the REML approach. The asymptotic variance-covariance matrix of the estimated covariate-specific TCFs is estimated through the Delta method. Note that, if the Box-Cox transformation is applied for the linear mixed-effect model, the pair of thresholds must be input in the original scale.

Before performing estimation, a check for the monotone ordering assumption is performed. This means that, for the fixed values of covariates, three predicted mean values for test results in three diagnostic groups are compared. If the assumption is not meet, the covariate-specific TCFs at the values of covariates are not estimated.
}
\examples{
data(data_3class)
## One covariate
out1 <- lme2(fixed.formula = Y ~ X1, name.class = "D", name.clust = "id_Clus",
             data = data_3class)

### Estimate TCFs at one single value of X1, (t1, t2) = (1, 4)
out_tcfs_1 <- TCFs(out_lme2 = out1, newdata = data.frame(X1 = 1),
                   thresholds = c(1, 4), apVar = TRUE)
print(out_tcfs_1)

## Two covariates
out2 <- lme2(fixed.formula = Y ~ X1 + X2, name.class = "D", name.clust = "id_Clus",
             data = data_3class)

### Estimate covariate-specific TCFs at point (X1, X2) = (1, 0), and (t1, t2) = (1, 4)
out_tcfs_2 <- TCFs(out_lme2 = out2, newdata = data.frame(X1 = 1, X2 = 0),
                   thresholds = c(1, 4), apVar = TRUE)
print(out_tcfs_2)

### Estimate covariate-specific TCFs at three points and (t1, t2) = (1, 4)
out_tcfs_3 <- TCFs(out_lme2 = out2,
                   newdata = data.frame(X1 = c(-0.5, 0.5, 0.5), X2 = c(0, 0, 1)),
                   thresholds = c(1, 4), apVar = TRUE)
print(out_tcfs_3)

}
\references{
To, D-K., Adimari, G., Chiogna, M. and Risso, D. (2022)
``Receiver operating characteristic estimation and threshold selection criteria in three-class classification problems for clustered data''. \emph{Statistical Methods in Medical Research}, DOI: 10.1177/09622802221089029.
}
