% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_desc_lsmeans.R
\name{gg_desc_lsmeans}
\alias{gg_desc_lsmeans}
\title{Creates a ggplot object corresponding to a LS Means desc object}
\usage{
gg_desc_lsmeans(desc, title = "", ylim = NULL, xlim, xlab = "",
  ylab = "", legend.label = "Group", add.ci = F, add.line = T)
}
\arguments{
\item{desc}{Desc object}

\item{title}{Character The title of the plot}

\item{ylim}{Numeric of length 2 for setting y axis limits}

\item{xlim}{Numeric of length 2 for setting x axis limits}

\item{xlab}{Character Label for x-axis}

\item{ylab}{Character Label for y-axis}

\item{legend.label}{Character Label for the legend (used only if x1 and x2 are not NULL in the desc object)}

\item{add.ci}{Logical. If TRUE it adds bars to the means representing 95\% CI}

\item{add.line}{Logical. If TRUE it joins the dots with a line (default to TRUE)}
}
\value{
A ggplot object.
}
\description{
\code{gg_desc_lsmeans} 
ggplot object is created. It is used internally in function \code{\link{plot.desc}}.
It's easier to use this last one.
}
\details{
It is used internally in function \code{\link{plot.desc}}.
It's easier to use this last one.
}
\examples{
\dontshow{

library(nlme)
library(emmeans)

data(data)
#Removing baseline data in the response, for the model

data.mod=droplevels(data[data$TIMEPOINT!="D0",]) 

mod3=lme(y_numeric~baseline+GROUP+TIMEPOINT+GROUP*TIMEPOINT,
random=~1|SUBJID,data=data.mod,na.action=na.omit)

test3=emmeans(mod3,~GROUP|TIMEPOINT)

tab.mod3=report.lsmeans(lsm=test3,x1="GROUP",
	x2="TIMEPOINT",at.row="TIMEPOINT",data=data.mod)

gg=gg_desc_lsmeans(tab.mod3,title="LS Means plot example")


test4=emmeans(mod3,~GROUP)
tab.mod4=report.lsmeans(lsm=test4,x1="GROUP",data=data.mod)

gg=gg_desc_lsmeans(tab.mod4,title="LS Means plot example")

gg2=gg_desc_lsmeans(tab.mod4,title="LS Means plot example",add.ci=TRUE)

}

}
\seealso{
\code{\link{plot.desc}} \code{\link{report.lsmeans}} \code{\link{gg_desc_quali}} \code{\link{gg_desc_quanti}}
}
