% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CEL.R
\name{CEL}
\alias{CEL}
\title{Constrained equal losses rule}
\usage{
CEL(E, d, name = FALSE)
}
\arguments{
\item{E}{The endowment.}

\item{d}{The vector of claims.}

\item{name}{A logical value.}
}
\value{
The awards vector selected by the CEL rule. If name = TRUE, the name of the function (CEL) as a character string.
}
\description{
This function returns the awards vector assigned by the constrained equal losses rule (CEL) to a claims problem.
}
\details{
Let \eqn{E\ge 0} be the endowment to be divided and let \eqn{d\in \mathcal{R}^n}{d} be the vector of claims
with \eqn{d\ge 0} and such that \eqn{\sum_{i=1}^{n} d_i\ge E,}{} the sum of claims exceeds the endowment.

The constrained equal losses rule (CEL) equalizes losses under the constraint that no award
is negative. Then, claimant \eqn{i} receives the maximum of zero and the claim minus a number \eqn{\lambda \ge 0} chosen so as to achieve balance.
\deqn{CEL_i(E,d)=\max\{0,d_i-\lambda\},\ i=1,\dots,n, \ such \  that  \ \sum_{i=1}^n CEL_i(E,d)=E.}{CEL(E,d)=(max\{0,di-\lambda\}).}

CEA and CEL are dual rules.
}
\examples{
E=10
d=c(2,4,7,8)
CEL(E,d)
# CEL and CEA are dual: CEL(E,d)=d-CEA(D-E,d)
D=sum(d)
d-CEA(D-E,d)
}
\references{
Maimonides, Moses, 1135-1204. Book of Judgements, Moznaim Publishing Corporation, New York, Jerusalem (Translated by Rabbi Elihahu Touger, 2000).

Thomson, W. (2019). How to divide when there isn't enough. From Aristotle, the Talmud, and Maimonides to the axiomatics of resource allocation. Cambridge University Press.
}
\seealso{
\link{allrules}, \link{CEA}
}
