% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indexpath.R
\name{indexpath}
\alias{indexpath}
\title{Proportionality index path}
\usage{
indexpath(d, Rules, col = NULL, points = 201, legend = TRUE)
}
\arguments{
\item{d}{The vector of claims.}

\item{Rules}{The rules: AA, APRO, CE, CEA, CEL, DT, MO, PIN, PRO, RA, Talmud.}

\item{col}{The colors. If col = NULL then the sequence of default colors is:
c("red", "blue", "green", "yellow", "pink", "coral4", "darkgray", "burlywood3", "black", "darkorange", "darkviolet").}

\item{points}{The number of endowment values to be drawn.}

\item{legend}{A logical value. The color legend is shown if legend = TRUE.}
}
\value{
This function returns the proportionality index path of a rule (or several rules) for a vector of claims.
}
\description{
The function returns the proportionality deviation index path of a rule for a vector of claims.
}
\details{
Let \eqn{d\in \mathcal{R}^n}{d} be  a vector of claims rearranged from small to large, \eqn{0 \le d_1 \le...\le d_n}{%
0 \le d1 \le...\le dn}.

Given a rule \eqn{R}, consider the function \eqn{J} that assigns to each \eqn{E\in (0,D]}{0<E\le D}
the value \eqn{J(E)=I(R,E,d)}, that is, the proportionality deviation index of the rule \eqn{R} for the problem \eqn{(E,d)}.
The graph of \eqn{J} is the index path of \eqn{R} for the vector of claims \eqn{d}.

The index path is a simple tool to visualize the discrepancy of the divisions
recommended by a rule for a vector of claims with respect to the proportional distribution and to compare it with other rules.
}
\examples{
d=c(2,4,7,8)
Rules=c(Talmud,RA,AA)
col=c("red","green","blue")
indexpath(d,Rules,col)
}
\references{
Mirás Calvo, M.A., Núñez Lugilde, I., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2021). Deviation from proportionality and Lorenz-dominance between
the average of awards and the standard rules for claims problems. Working paper 2021-01, ECOBAS.

Thomson, W. (2019). How to divide when there isn't enough. From Aristotle, the Talmud, and Maimonides to the axiomatics of resource allocation. Cambridge University Press.
}
\seealso{
\link{proportionalityindex}, \link{cumulativecurve}, \link{giniindex}, \link{lorenzcurve}, \link{lorenzdominance}, \link{PRO}.
}
