% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{may}
\alias{may}
\title{May waves.}
\format{\describe{
\item{object}{each element of the list is one hour of data on the entire area}
\item{Date}{Date, format: yyyy-mm-dd}
\item{hour}{Factor w/ 24 levels corresponding to the 24h, format: 00:00}
\item{Lon, Lat}{decimal longitude and latitude}
\item{Hm0}{Significant wave heights in meters}
\item{Dm}{Direction of waves in degrees (North=0)}
\item{state}{Factor w/ 3 levels "calm","transition", "storm"}
}}
\source{
R. Inghilesi, A. Orasi & F. Catini (2016) The ISPRA Mediterranean Coastal Wave Forecasting system: evaluation and perspectives  Journal of Operational Oceanography Vol. 9 , Iss. sup1 \url{http://www.tandfonline.com/doi/full/10.1080/1755876X.2015.1115635}
}
\usage{
may
}
\description{
Four time slices of waves data on the Adriatic sea in the month of May 2010.
}
\details{
Wave directions and heights are obtained as outputs from a deterministic
computer model implemented by Istituto Superiore per la Protezione e
la Ricerca Ambientale (ISPRA).
The computer model starts from a wind forecast model predicting
the surface wind over the entire Mediterranean.
The hourly evolution of sea wave spectra is obtained by
solving energy transport equations using the wind forecast as input.
Wave spectra are locally modified using a source function describing the wind
 energy, the energy redistribution due to nonlinear wave interactions,
 and energy dissipation due to wave fracture.
The model produces estimates every hour
on a grid with 10 x 10 km cells (Inghilesi et al. 2016).
The ISPRA dataset has forecasts for a total of 4941 grid points
over the Italian Mediterranean.
Over the Adriatic Sea area, there are 1494 points.

A list containing 4 data frames each of 1494 rows and 7 columns.
}
\keyword{datasets}
