/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.jayes.inference.jtree;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.recommenders.internal.jayes.util.UnionFind;
import org.eclipse.recommenders.jayes.BayesNet;
import org.eclipse.recommenders.jayes.inference.jtree.JunctionTree;
import org.eclipse.recommenders.jayes.util.Graph;
import org.eclipse.recommenders.jayes.util.OrderIgnoringPair;
import org.eclipse.recommenders.jayes.util.Pair;

public class SepsetComputer {
    public List<Pair<OrderIgnoringPair<Integer>, List<Integer>>> computeSepsets(JunctionTree junctionTree, BayesNet net) {
        List<Pair<OrderIgnoringPair<Integer>, List<Integer>>> candidates = this.enumerateCandidateSepSets(junctionTree.getClusters());
        Collections.sort(candidates, new SepsetComparator(net));
        return this.computeMaxSpanningTree(junctionTree.getGraph(), candidates);
    }

    private List<Pair<OrderIgnoringPair<Integer>, List<Integer>>> enumerateCandidateSepSets(List<List<Integer>> clusters) {
        ArrayList<Pair<OrderIgnoringPair<Integer>, List<Integer>>> sepSets = new ArrayList<Pair<OrderIgnoringPair<Integer>, List<Integer>>>();
        ListIterator<List<Integer>> it = clusters.listIterator();
        while (it.hasNext()) {
            List<Integer> clique1 = it.next();
            ListIterator<List<Integer>> remainingIt = clusters.listIterator(it.nextIndex());
            while (remainingIt.hasNext()) {
                ArrayList clique2 = new ArrayList(remainingIt.next());
                clique2.retainAll(clique1);
                sepSets.add(Pair.newPair(new OrderIgnoringPair<Integer>(it.nextIndex() - 1, remainingIt.nextIndex() - 1), clique2));
            }
        }
        return sepSets;
    }

    private List<Pair<OrderIgnoringPair<Integer>, List<Integer>>> computeMaxSpanningTree(Graph graph, List<Pair<OrderIgnoringPair<Integer>, List<Integer>>> sortedCandidateSepSets) {
        ArrayDeque<Pair<OrderIgnoringPair<Integer>, List<Integer>>> pq = new ArrayDeque<Pair<OrderIgnoringPair<Integer>, List<Integer>>>(sortedCandidateSepSets);
        int vertexCount = graph.numberOfVertices();
        UnionFind[] sets = UnionFind.createArray(vertexCount);
        ArrayList<Pair<OrderIgnoringPair<Integer>, List<Integer>>> leftSepSets = new ArrayList<Pair<OrderIgnoringPair<Integer>, List<Integer>>>();
        while (leftSepSets.size() < vertexCount - 1) {
            boolean bothEndsInSameTree;
            Pair<OrderIgnoringPair<Integer>, List<Integer>> sep = pq.poll();
            boolean bl = bothEndsInSameTree = sets[sep.getFirst().getFirst()].find() == sets[sep.getFirst().getSecond()].find();
            if (bothEndsInSameTree) continue;
            sets[sep.getFirst().getFirst()].merge(sets[sep.getFirst().getSecond()]);
            leftSepSets.add(sep);
            graph.addEdge(sep.getFirst().getFirst(), sep.getFirst().getSecond());
        }
        return leftSepSets;
    }

    private final class SepsetComparator
    implements Comparator<Pair<OrderIgnoringPair<Integer>, List<Integer>>> {
        private final BayesNet net;

        public SepsetComparator(BayesNet net) {
            this.net = net;
        }

        @Override
        public int compare(Pair<OrderIgnoringPair<Integer>, List<Integer>> sepSet1, Pair<OrderIgnoringPair<Integer>, List<Integer>> sepSet2) {
            int compareNumberOfVariables = this.compare(sepSet1.getSecond().size(), sepSet2.getSecond().size());
            if (compareNumberOfVariables != 0) {
                return -compareNumberOfVariables;
            }
            int tableSize1 = this.getTableSize(sepSet1.getSecond());
            int tableSize2 = this.getTableSize(sepSet2.getSecond());
            return this.compare(tableSize1, tableSize2);
        }

        private int getTableSize(List<Integer> cluster) {
            int tableSize = 1;
            for (int id : cluster) {
                tableSize *= this.net.getNode(id).getOutcomeCount();
            }
            return tableSize;
        }

        @Override
        private int compare(int i1, int i2) {
            return i1 - i2;
        }
    }
}

