% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcLvls.R
\name{calcLvls}
\alias{calcLvls}
\title{Calculate Levels for Contour and Image Type Plots}
\usage{
calcLvls(
  M,
  n = 10,
  mode = "even",
  lambda = 1.5,
  base = 2,
  showHist = FALSE,
  ...
)
}
\arguments{
\item{M}{A numeric matrix or vector.}

\item{n}{An integer giving the number of levels desired:
\itemize{
  \item For \code{mode = "even"} \code{n} evenly spaced levels are returned.
  \item For \code{mode = "ecdf"}, \code{n} should be one or more values in the interval [0...1].
        For instance, a value of 0.6 corresponds to a single level in which 60 percent
        of the matrix values are below, and 40 percent above.
 \item For all other values of \code{mode}, \code{n} is used internally as \code{floor(n/2)}
       and the result eventually doubled in order to give a symmetric set of levels. In addition,
       only the positive or negative levels may be selected, leaving you with
       \code{floor(n/2)/2} levels.
}}

\item{mode}{Character.  One of \code{"even"}, \code{"log"}, \code{"exp"},
\code{"ecdf"}, \code{"posexp"}, \code{"negexp"}, \code{"poslog"}, \code{"neglog"}
or \code{NMR}. \code{"even"} will create evenly
spaced levels.  \code{"log"} will create levels which are more closely
spaced at the high values, while \code{"exp"} does the opposite.  The pos- or
neg- versions select just the positive or negative values.  \code{"ecdf"}
computes levels at the requested quantiles of the matrix. \code{NMR} uses
\code{exp}, \code{lambda = 2.0} and \code{n = 32}.  It also removes the four
values closest to zero, where the data may be primarily noise.}

\item{lambda}{Numeric.  A non-zero exponent used with \code{method = "exp"}
and relatives.  Higher values push the levels toward zero.}

\item{base}{Integer.  The base used with \code{method = "log"} and
relatives.}

\item{showHist}{Logical.  Shall a histogram be drawn showing the location of
the chosen levels?}

\item{\dots}{Arguments to be passed downstream.}
}
\value{
A numeric vector giving the levels.
}
\description{
Given a matrix or vector input, this function will assist in selecting levels for preparing
contour and image type plots.  For instance, levels can be spaced evenly,
logrithmically, exponentially or using a cumulative distribution function.
\code{NA} values are ignored.
}
\examples{

set.seed(9)
MM <- matrix(runif(100, -1, 1), nrow = 10) # test data
tsts <- c("even", "log", "poslog", "exp", "posexp", "ecdf", "NMR")
for (i in 1:length(tsts)) {
  nl <- 20
  if (tsts[i] == "ecdf") nl <- seq(0.1, 0.9, 0.1)
  levels <- calcLvls(
    M = MM, n = nl, mode = tsts[i],
    showHist = TRUE, main = tsts[i]
  )
}
}
\author{
Bryan A. Hanson, DePauw University. \email{hanson@depauw.edu}
}
\keyword{utilities}
