% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotLoadings.R
\name{plotLoadings}
\alias{plotLoadings}
\title{Plot PCA Loadings for a Spectra Object}
\usage{
plotLoadings(spectra, pca, loads = c(1), ref = 1, ...)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link{Spectra}}.}

\item{pca}{An object of class \code{\link{prcomp}}, modified to include a
list element called \code{$method}, a character string describing the
pre-processing carried out and the type of PCA performed (it appears on the
plot).  This is automatically provided if \code{ChemoSpec} functions
\code{\link{c_pcaSpectra}} or \code{\link{r_pcaSpectra}} were used to create
\code{pca}.}

\item{loads}{An integer vector giving the loadings to plot.  More than 3
loadings creates a useless plot using the default graphics window.}

\item{ref}{An integer specifying the reference spectrum to plot, which
appears at the bottom of the plot.}

\item{\dots}{Parameters to be passed to the plotting routines. \emph{Applies to base graphics only}.}
}
\value{
The returned value depends on the graphics option selected (see \code{\link{GraphicsOptions}}).
\describe{
 \item{base:}{None. Side effect is a plot.}
 \item{ggplot2:}{The plot is displayed, and a \code{ggplot2} plot object is returned if the
                 value is assigned. The plot can be modified in the usual \code{ggplot2} manner.}
}
}
\description{
Creates a multi-panel plot of loadings along with a reference spectrum.
}
\seealso{
\code{\link{c_pcaSpectra}} for an example.  See \code{\link{plot2Loadings}}
to plot two loadings against each
other, and \code{\link{sPlotSpectra}} for an alternative approach.
Additional documentation at \url{https://bryanhanson.github.io/ChemoSpec/}
}
\author{
Bryan A. Hanson (DePauw University), Tejasvi Gupta.
}
\keyword{hplot}
\keyword{multivariate}
