% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elementwise.R
\docType{class}
\name{MinElemwise-class}
\alias{MinElemwise-class}
\alias{.MinElemwise}
\alias{MinElemwise}
\alias{to_numeric,MinElemwise-method}
\alias{sign_from_args,MinElemwise-method}
\alias{is_atom_convex,MinElemwise-method}
\alias{is_atom_concave,MinElemwise-method}
\alias{is_atom_log_log_convex,MinElemwise-method}
\alias{is_atom_log_log_concave,MinElemwise-method}
\alias{is_incr,MinElemwise-method}
\alias{is_decr,MinElemwise-method}
\alias{is_pwl,MinElemwise-method}
\alias{.grad,MinElemwise-method}
\title{The MinElemwise class.}
\usage{
MinElemwise(arg1, arg2, ...)

\S4method{to_numeric}{MinElemwise}(object, values)

\S4method{sign_from_args}{MinElemwise}(object)

\S4method{is_atom_convex}{MinElemwise}(object)

\S4method{is_atom_concave}{MinElemwise}(object)

\S4method{is_atom_log_log_convex}{MinElemwise}(object)

\S4method{is_atom_log_log_concave}{MinElemwise}(object)

\S4method{is_incr}{MinElemwise}(object, idx)

\S4method{is_decr}{MinElemwise}(object, idx)

\S4method{is_pwl}{MinElemwise}(object)

\S4method{.grad}{MinElemwise}(object, values)
}
\arguments{
\item{arg1}{The first \linkS4class{Expression} in the minimum operation.}

\item{arg2}{The second \linkS4class{Expression} in the minimum operation.}

\item{...}{Additional \linkS4class{Expression} objects in the minimum operation.}

\item{object}{A \linkS4class{MinElemwise} object.}

\item{values}{A list of numeric values for the arguments}

\item{idx}{An index into the atom.}
}
\description{
This class represents the elementwise minimum.
}
\section{Methods (by generic)}{
\itemize{
\item \code{to_numeric(MinElemwise)}: The elementwise minimum.

\item \code{sign_from_args(MinElemwise)}: The sign of the atom.

\item \code{is_atom_convex(MinElemwise)}: The atom is not convex.

\item \code{is_atom_concave(MinElemwise)}: The atom is not concave.

\item \code{is_atom_log_log_convex(MinElemwise)}: Is the atom log-log convex?

\item \code{is_atom_log_log_concave(MinElemwise)}: Is the atom log-log concave?

\item \code{is_incr(MinElemwise)}: The atom is weakly increasing.

\item \code{is_decr(MinElemwise)}: The atom is not weakly decreasing.

\item \code{is_pwl(MinElemwise)}: Are all the arguments piecewise linear?

\item \code{.grad(MinElemwise)}: Gives the (sub/super)gradient of the atom w.r.t. each variable

}}
\section{Slots}{

\describe{
\item{\code{arg1}}{The first \linkS4class{Expression} in the minimum operation.}

\item{\code{arg2}}{The second \linkS4class{Expression} in the minimum operation.}

\item{\code{...}}{Additional \linkS4class{Expression} objects in the minimum operation.}
}}

