% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elementwise.R
\docType{class}
\name{Exp-class}
\alias{Exp-class}
\alias{.Exp}
\alias{Exp}
\alias{to_numeric,Exp-method}
\alias{sign_from_args,Exp-method}
\alias{is_atom_convex,Exp-method}
\alias{is_atom_concave,Exp-method}
\alias{is_atom_log_log_convex,Exp-method}
\alias{is_atom_log_log_concave,Exp-method}
\alias{is_incr,Exp-method}
\alias{is_decr,Exp-method}
\alias{.grad,Exp-method}
\title{The Exp class.}
\usage{
Exp(x)

\S4method{to_numeric}{Exp}(object, values)

\S4method{sign_from_args}{Exp}(object)

\S4method{is_atom_convex}{Exp}(object)

\S4method{is_atom_concave}{Exp}(object)

\S4method{is_atom_log_log_convex}{Exp}(object)

\S4method{is_atom_log_log_concave}{Exp}(object)

\S4method{is_incr}{Exp}(object, idx)

\S4method{is_decr}{Exp}(object, idx)

\S4method{.grad}{Exp}(object, values)
}
\arguments{
\item{x}{An \linkS4class{Expression} object.}

\item{object}{An \linkS4class{Exp} object.}

\item{values}{A list of numeric values for the arguments}

\item{idx}{An index into the atom.}
}
\description{
This class represents the elementwise natural exponential \eqn{e^x}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{to_numeric}: The matrix with each element exponentiated.

\item \code{sign_from_args}: The atom is positive.

\item \code{is_atom_convex}: The atom is convex.

\item \code{is_atom_concave}: The atom is not concave.

\item \code{is_atom_log_log_convex}: Is the atom log-log convex?

\item \code{is_atom_log_log_concave}: Is the atom log-log concave?

\item \code{is_incr}: The atom is weakly increasing.

\item \code{is_decr}: The atom is not weakly decreasing.

\item \code{.grad}: Gives the (sub/super)gradient of the atom w.r.t. each variable
}}

\section{Slots}{

\describe{
\item{\code{x}}{An \linkS4class{Expression} object.}
}}

