% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mosek-solver.R
\docType{class}
\name{MOSEK-class}
\alias{MOSEK-class}
\alias{MOSEK}
\alias{MOSEK}
\alias{lp_capable,MOSEK-method}
\alias{socp_capable,MOSEK-method}
\alias{sdp_capable,MOSEK-method}
\alias{exp_capable,MOSEK-method}
\alias{mip_capable,MOSEK-method}
\alias{name,MOSEK-method}
\alias{import_solver,MOSEK-method}
\alias{Solver.solve,MOSEK-method}
\title{The MOSEK class.}
\usage{
MOSEK()

\S4method{lp_capable}{MOSEK}(solver)

\S4method{socp_capable}{MOSEK}(solver)

\S4method{sdp_capable}{MOSEK}(solver)

\S4method{exp_capable}{MOSEK}(solver)

\S4method{mip_capable}{MOSEK}(solver)

\S4method{name}{MOSEK}(object)

\S4method{import_solver}{MOSEK}(solver)

\S4method{Solver.solve}{MOSEK}(solver, objective, constraints, cached_data,
  warm_start, verbose, ...)
}
\arguments{
\item{object, solver}{A \linkS4class{MOSEK} object.}

\item{objective}{A list representing the canonicalized objective.}

\item{constraints}{A list of canonicalized constraints.}

\item{cached_data}{A list mapping solver name to cached problem data.}

\item{warm_start}{A logical value indicating whether the previous solver result should be used to warm start.}

\item{verbose}{A logical value indicating whether to print solver output.}

\item{...}{Additional arguments to the solver.}
}
\description{
This class is an interface for the commercial MOSEK solver.
}
\section{Methods (by generic)}{
\itemize{
\item \code{lp_capable}: MOSEK can handle linear programs.

\item \code{socp_capable}: MOSEK can handle second-order cone programs.

\item \code{sdp_capable}: MOSEK can handle semidefinite programs.

\item \code{exp_capable}: MOSEK cannot handle exponential cone programs.

\item \code{mip_capable}: MOSEK cannot handle mixed-integer programs.

\item \code{name}: The name of the solver.

\item \code{import_solver}: Imports the reticulate library to use the python solver.

\item \code{Solver.solve}: Call the solver on the canonicalized problem.
}}

\references{
E. Andersen and K. Andersen. "The MOSEK Interior Point Optimizer for Linear Programming: an Implementation of the Homogeneous Algorithm." \emph{High Performance Optimization}, vol. 33, pp. 197-232, 2000.
}
\seealso{
the \href{https://www.mosek.com/products/mosek/}{MOSEK Official Site}.
}
