% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/affine.R
\docType{class}
\name{CumSum-class}
\alias{CumSum-class}
\alias{.CumSum}
\alias{CumSum}
\alias{CumSum}
\alias{to_numeric,CumSum-method}
\alias{size_from_args,CumSum-method}
\alias{validate_args,CumSum-method}
\alias{graph_implementation,CumSum-method}
\title{The CumSum class.}
\usage{
CumSum(expr, axis = 2)

\S4method{to_numeric}{CumSum}(object, values)

\S4method{size_from_args}{CumSum}(object)

\S4method{validate_args}{CumSum}(object)

\S4method{graph_implementation}{CumSum}(object, arg_objs, size,
  data = NA_real_)
}
\arguments{
\item{expr}{An \linkS4class{Expression} to be summed.}

\item{axis}{(Optional) The dimension across which to apply the function: \code{1} indicates rows, and \code{2} indicates columns. The default is \code{2}.}

\item{object}{A \linkS4class{CumSum} object.}

\item{values}{A list of arguments to the atom.}

\item{arg_objs}{A list of linear expressions for each argument.}

\item{size}{A vector with two elements representing the size of the resulting expression.}

\item{data}{A list of additional data required by the atom.}
}
\description{
This class represents the cumulative sum.
}
\section{Methods (by generic)}{
\itemize{
\item \code{to_numeric}: The cumulative sum of the values along the specified axis.

\item \code{size_from_args}: The size of the atom.

\item \code{validate_args}: Check that axis is either 1 or 2.

\item \code{graph_implementation}: The graph implementation of the atom.
}}

\section{Slots}{

\describe{
\item{\code{expr}}{An \linkS4class{Expression} to be summed.}

\item{\code{axis}}{(Optional) The dimension across which to apply the function: \code{1} indicates rows, and \code{2} indicates columns. The default is \code{2}.}
}}

