% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation.R
\name{estimate_ridge}
\alias{estimate_ridge}
\title{Estimating a Single Model}
\usage{
estimate_ridge(
  Y,
  X,
  K,
  lambda,
  compute_kernel_terms = TRUE,
  converge_thres = 1e-04
)
}
\arguments{
\item{Y}{(matrix, n*1) The vector of response variable.}

\item{X}{(matrix, n*d_fix) The fixed effect matrix.}

\item{K}{(list of matrices) A nested list of kernel term matrices, 
corresponding to each kernel term specified in the formula for 
a base kernel function in kern_func_list.}

\item{lambda}{(numeric) A numeric string specifying the range of tuning parameter 
to be chosen. The lower limit of lambda must be above 0.}

\item{compute_kernel_terms}{(logic) Whether to computing effect for each individual terms.
If FALSE then only compute the overall effect.}

\item{converge_thres}{(numeric) The convergence threshold for computing kernel terms.}
}
\value{
\item{beta}{(matrix, d_fixed*1) Fixed effect estimates.}

\item{alpha}{(matrix, n*k_terms) Kernel effect estimates for each kernel term.}

\item{kern_term_mat}{(matrix, n*k_terms) Kernel effect for each kernel term.}

\item{A_list}{(list of length k_terms) Projection matrices for each kernel term.}

\item{proj_matrix}{(list of length 4) Estimated projection matrices, combined 
across kernel terms.}
}
\description{
Estimating projection matrices and parameter estimates for a single model.
}
\details{
For a single model, we can calculate the output of gaussian process
regression, the solution is given by \deqn{\hat{\beta}=[X^T(K+\lambda
I)^{-1}X]^{-1}X^T(K+\lambda I)^{-1}y} \deqn{\hat{\alpha}=(K+\lambda
I)^{-1}(y-\hat{\beta}X)}.
}
\references{
Andreas Buja, Trevor Hastie, and Robert Tibshirani. (1989) 
Linear Smoothers and Additive Models. Ann. Statist. Volume 17, Number 2, 453-510.
}
\author{
Wenying Deng
}
