% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testing.R
\name{test_boot}
\alias{test_boot}
\title{Conducting Score Tests for Interaction Using Bootstrap Test}
\usage{
test_boot(Y, X, y_fixed, alpha0, K_ens, K_int, sigma2_hat, tau_hat, B)
}
\arguments{
\item{Y}{(matrix, n*1) The vector of response variable.}

\item{X}{(matrix, n*d_fix) The fixed effect matrix.}

\item{y_fixed}{(vector of length n) Estimated fixed effect of the
response.}

\item{alpha0}{(vector of length n) Kernel effect estimator of the estimated
ensemble kernel matrix.}

\item{K_ens}{(matrix, n*n) Estimated ensemble kernel matrix.}

\item{K_int}{(matrix, n*n) The kernel matrix to be tested.}

\item{sigma2_hat}{(numeric) The estimated noise of the fixed effect.}

\item{tau_hat}{(numeric) The estimated noise of the kernel effect.}

\item{B}{(integer) A numeric value indicating times of resampling when test
= "boot".}
}
\value{
\item{pvalue}{(numeric) p-value of the test.}
}
\description{
Conduct score tests comparing a fitted model and a more general alternative
model using bootstrap test.
}
\details{
\bold{Bootstrap Test}

When it comes to small sample size, we can use bootstrap test instead, which
can give valid tests with moderate sample sizes and requires similar
computational effort to a permutation test.
}
\references{
Xihong Lin. Variance component testing in generalised linear
models with random effects. June 1997.

Arnab Maity and Xihong Lin. Powerful tests for detecting a gene effect in
the presence of possible gene-gene interactions using garrote kernel
machines. December 2011.

Petra Bu z kova, Thomas Lumley, and Kenneth Rice. Permutation and
parametric bootstrap tests for gene-gene and gene-environment interactions.
January 2011.
}
\seealso{
method: \code{\link{generate_kernel}}

mode: \code{\link{tuning}}

strategy: \code{\link{ensemble}}
}
\author{
Wenying Deng
}
