% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglikCUSH.R
\name{loglikCUSH}
\alias{loglikCUSH}
\title{Log-likelihood function for CUSH models}
\usage{
loglikCUSH(ordinal,m,param,shelter,X=0)
}
\arguments{
\item{ordinal}{Vector of ordinal responses (factor type)}

\item{m}{Number of ordinal categories}

\item{param}{Vector of parameters for the specified CUSH model}

\item{shelter}{Category corresponding to the shelter choice}

\item{X}{Matrix of selected covariates to explain the shelter effect (default: no covariate 
is included in the model)}
}
\description{
Compute the log-likelihood function for CUSH models with or without covariates 
to explain the shelter effect.
}
\details{
If no covariate is included in the model, then \code{param} is the estimate of the shelter 
parameter (delta), otherwise \code{param} has length equal to NCOL(X) + 1 to account for an intercept  
term (first entry)
}
\examples{
## Log-likelihood of CUSH model without covariates
n<-300
m<-7
shelter<-2; delta<-0.4
ordinal<-simcush(n,m,delta,shelter)
loglik<-loglikCUSH(ordinal,m,param=delta,shelter)
#####################
## Log-likelihood of CUSH model with covariates
data(relgoods); attach(relgoods)
m<-10
naord<-which(is.na(SocialNetwork))
nacov<-which(is.na(Gender))
na<-union(nacov,naord)
ordinal<-SocialNetwork[-na]; cov<-Gender[-na]
omega<-c(-2.29, 0.62)
loglikcov<-loglikCUSH(ordinal,m,param=omega,shelter=1,X=cov)
}
\seealso{
\code{\link{GEM}}, \code{\link{logLik}}
}
\keyword{htest}

