% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varcube.R
\name{varcube}
\alias{varcube}
\title{Variance of CUBE models without covariates}
\usage{
varcube(m, pai, csi, phi)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{pai}{Uncertainty parameter}

\item{csi}{Feeling parameter}

\item{phi}{Overdispersion parameter}
}
\description{
Compute the variance of a CUBE model without covariates.
}
\examples{
m<-7
pai<-0.8
csi<-0.2
phi<-0.05
varianceCUBE<-varcube(m, pai, csi, phi)
}
\references{
Iannario, M. (2014). Modelling Uncertainty and Overdispersion in 
Ordinal Data,  \emph{Communications in Statistics - Theory and Methods}, \bold{43}, 
771--786
}
\seealso{
\code{\link{CUBE}}, \code{\link{probcube}}, \code{\link{expcube}}
}
\keyword{distribution}

