% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multicub.R
\name{multicub}
\alias{multicub}
\title{Joint plot of estimated CUB models in the parameter space}
\usage{
multicub(matord, m, labelpoints=as.character(1:ncol(matord)), 
caption="CUB models", colours="black", symbols=19, 
thickness=1.5, xwidth=c(0,1), ywidth=c(0,1))
}
\arguments{
\item{matord}{Matrix of ordinal data arranged per columns}

\item{m}{Number of ordinal categories}

\item{labelpoints}{Character strings indicating the labels for the estimated models as points
in the parameter space (default is the corresponding index of column in matord)}

\item{caption}{Character string indicating the plot title (default is "CUB models")}

\item{colours}{Indicate the colours for the plotted points}

\item{symbols}{Indicate the symbols used to represent estimated CUB models as points in the
parameter space}

\item{thickness}{Indicate the thickness}

\item{xwidth}{Indicate the width of the abscissa axis}

\item{ywidth}{Indicate the width of the ordinate axis}
}
\description{
Return a plot of estimated CUB models represented as points in the parameter space.
}
\examples{
data(univer)
matord<-univer[,8:12]
m<-7
multicub(matord, m, labelpoints=as.character(1:ncol(matord)), 
        caption ="CUB models", colours="black", symbols=19,
        thickness=1.5, xwidth=c(0,1), ywidth=c(0,1))
}
\keyword{device}

