% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/point_biserial_plot.R
\name{point_biserial_plot}
\alias{point_biserial_plot}
\title{point_biserial_visualization}
\usage{
point_biserial_plot(
  responses,
  title = "Item Discrimination",
  pBis_threshold = 0.2
)
}
\arguments{
\item{responses}{A dichotompus item response object (a dataframe or a matrix)}

\item{title}{Title of the plot}

\item{pBis_threshold}{Threshold of the point-biserial correlation (pBis)}
}
\value{
A data frame sorted by item discrimination in ascending order. A plot of item discrimination in relation to the specified threshold.
}
\description{
plotting results of item discrimination analysis from the Classical test theory framework
}
\examples{

data(dichotomous_response)

# To plot item discrimination with pBis threshol of .20.

point_biserial_plot(responses = dichotomous_response,
      title = "Item Discrimination Plot", pBis_threshold = 0.20)

}
