% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.naivePruning.r
\name{graph.naivePruning}
\alias{graph.naivePruning}
\title{Network pruning for disease-specific network determination}
\usage{
graph.naivePruning(ig_dis, ig_ref)
}
\arguments{
\item{ig_dis}{- The igraph object associated with the
disease+reference trained differential network.}

\item{ig_ref}{- The igraph object associated with the reference-only
trained interaction network.}
}
\value{
ig_pruned - The pruned igraph object of the disease+reference
differential network, with reference edges subtracted.
}
\description{
Prune edges from a disease+control "differential" network that also 
occur in the control-only network.
}
\examples{
# Generate a 100 node "disease-control" network
adj_mat=matrix(0, nrow=100, ncol=100)
rows = sample(seq_len(100), 50, replace=TRUE)
cols = sample(seq_len(100), 50, replace=TRUE)
for (i in rows) {for (j in cols){adj_mat[i,j]=rnorm(1,0,1)}}
colnames(adj_mat)=sprintf("Metabolite\%d", seq_len(100))
ig_dis = graph.adjacency(adj_mat, mode="undirected", weighted=TRUE)
# Generate a 100 node reference "control-only" network
adj_mat2=matrix(0, nrow=100, ncol=100)
rows2 = sample(seq_len(100), 50, replace=TRUE)
cols2 = sample(seq_len(100), 50, replace=TRUE)
for (i in rows2) {for (j in cols2){adj_mat2[i,j]=rnorm(1,0,1)}}
colnames(adj_mat2)=sprintf("Metabolite\%d", seq_len(100))
ig_ref = graph.adjacency(adj_mat2, mode="undirected", weighted=TRUE)
ig_pruned=graph.naivePruning(ig_dis, ig_ref)
}
