% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_AdamontQQCorr.R
\name{CST_AdamontQQCorr}
\alias{CST_AdamontQQCorr}
\title{CST_AdamontQQCorr computes quantile-quantile correction of seasonal or 
decadal forecast data using weather types}
\usage{
CST_AdamontQQCorr(
  exp,
  wt_exp,
  obs,
  wt_obs,
  corrdims = c("member", "sdate", "ftime"),
  londim = "lon",
  latdim = "lat"
)
}
\arguments{
\item{exp}{experiment data an object of class \code{s2dv_cube}}

\item{wt_exp}{corresponding weather types (same dimensions as \code{exp$data}
but lat/lon)}

\item{obs}{reference data, also of class \code{s2dv_cube}. lat/lon dimensions
can differ from \code{exp} if non rectilinear latlon grids are used, 
in which case regrid should be set to TRUE and .NearestNeighbors \code{NN}
output should be provided}

\item{wt_obs}{corresponding weather types (same dimensions as \code{obs} but
lat/lon)}

\item{corrdims}{list of dimensions in \code{exp} for which quantile mapping
correction is applied}

\item{londim}{character name of longitude dimension in \code{exp} and 
\code{obs}}

\item{latdim}{character name of latitude dimension in \code{exp} and 
\code{obs}}
}
\value{
an object of class \code{s2dv_cube} containing experiment data on the
   lat/lon grid of \code{obs} input data, corrected by quantile mapping 
   depending on the weather types \code{wt_exp}
}
\description{
This function computes a quantile mapping based on weather types 
for experiment data (typically a hindcast) onto reference \code{obs},
typically provided by reanalysis data.
}
\examples{
\dontrun{
wt_exp <- sample(1:3, 15*6*3, replace=T)
dim(wt_exp) <- c(dataset=1, member=15, sdate=6, ftime=3)
wt_obs <- sample(1:3, 6*3, replace=T)
dim(wt_obs) <- c(dataset=1, member=1, sdate=6, ftime=3)
exp_corr <- CST_AdamontQQCorr(exp = lonlat_temp$exp, wt_exp = wt_exp, 
   obs=lonlat_temp$obs, wt_obs = wt_obs, 
   corrdims = c('dataset','member','sdate','ftime'))
}
}
\author{
Lauriane Batté, \email{lauriane.batte@meteo.fr}

Paola Marson, \email{paola.marson@meteo.fr}

Gildas Dayon, \email{gildas.dayon@meteo.fr}
}
