% Generated by roxygen2 (4.0.1): do not edit by hand
\name{clamp.crf}
\alias{clamp.crf}
\title{Make clamped CRF}
\usage{
clamp.crf(crf, clamped)
}
\arguments{
\item{crf}{The CRF generated by \code{\link{make.crf}}}

\item{clamped}{The vector of fixed states of nodes}
}
\value{
The function will return a new CRF with additional components:
  \item{original}{The original CRF.}
  \item{clamped}{The vector of fixed states of nodes.}
  \item{node.id}{The vector of the original node ids for nodes in the new CRF.}
  \item{node.map}{The vector of the new node ids for nodes in the original CRF.}
  \item{edge.id}{The vector of the original edge ids for edges in the new CRF.}
  \item{edge.map}{The vector of the new edge ids for edges in the original CRF.}
}
\description{
Generate clamped CRF by fixing the states of some nodes
}
\details{
The function will generate a clamped CRF from a given CRF
by fixing the states of some nodes. The vector \code{clamped}
contains the desired state for each node while zero means the state is not
fixed. The node and edge potentials are updated to the conditional
potentials based on the clamped vector.
}
\examples{
library(CRF)
data(Small)
crf <- clamp.crf(Small$crf, c(0, 0, 1, 1))
}
\seealso{
\code{\link{make.crf}}, \code{\link{sub.crf}}, \code{\link{clamp.reset}}
}

