% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{post_summaries}
\alias{post_summaries}
\title{Post summary of the MCMC data generated by the uncorrelated or correlated version of CPBayes.}
\usage{
post_summaries(mcmc_output, level = 0.05)
}
\arguments{
\item{mcmc_output}{A list returned by either of the two main CPBayes functions
 \code{\link{cpbayes_uncor}} and \code{\link{cpbayes_cor}}. This list 
contains all the primary results and MCMC data produced by \code{\link{cpbayes_uncor}}
 or \code{\link{cpbayes_cor}}. No default is specified. See the example below.}

\item{level}{A numeric value. (1-level)\% credible interval (Bayesian analog of the
confidence interval) is computed for the true unknown genetic effect (beta/odds ratio)
 on the traits. Default choice is 0.05.}
}
\value{
The output produced by this function is a list that consists of various components. 
   \item{variantName}{It is the name of the genetic variant provided by the user. If not
    specified by the user, default name is `variant'.} 
   \item{log10_BF}{It provides the log10(Bayes factor) produced by CPBayes that measures
    the evidence of the overall pleiotropic association.}
   \item{PPNA}{It provides the posterior probability of null association produced by
    CPBayes (a Bayesian analog of the p-value) which is another measure of the evidence
     of aggregate-level pleiotropic association.}
   \item{subset}{A data frame providing the optimal subset of associated/non-null traits
    along with their trait-specific posterior probability of association (PPAj) and direction
     of associations. It is NULL if no phenotype is selected by CPBayes.}
   \item{important_traits}{It provides the traits which yield a trait-specific posterior
    probability of association (PPAj) > 25\%. Even if a phenotype is not selected in the
   optimal subset of non-null traits, it can produce a non-negligible value of
    trait-specific posterior probability of association. We note that `important_traits'
     is expected to include the traits already contained in `subset'. It provides the
      name of the important traits and their trait-specific posterior probability of
       association (PPAj) and the direction of associations. Always check out
        'important_traits' even if 'subset' contains no trait or a single trait.
         It helps to better explain an observed pleiotropic signal.}
    \item{traitNames}{It returns the name of all the phenotypes specified by the user.
     Default is trait1, trait2, ... , traitK.}
    \item{PPAj}{Data frame provaiding the trait-specific posterior probability of
     association for all the phenotypes.}
    \item{poste_summary_beta}{Data frame providing the posterior summary of the
     unknown true genetic effect (beta) on each trait. It gives posterior mean,
      median, standard error, credible interval (lower and upper limits) of the
       unknown true beta corresponding to each trait.}
    \item{poste_summary_OR}{Data frame providing the posterior summary of the unknown
     true genetic effect (odds ratio) on each trait. It gives posterior mean, median,
      standard error, credible interval (lower and upper limits) of the unknown true odds 
       ratio corresponding to each trait.}
}
\description{
Run the \code{\link{post_summaries}} function to summarize the MCMC data produced by
 \code{\link{cpbayes_uncor}} or \code{\link{cpbayes_cor}} and obtain meaningful insights
  into an observed pleiotropic signal.
}
\examples{
data(ExampleDataUncor)
BetaHat <- ExampleDataUncor$BetaHat
BetaHat
SE <- ExampleDataUncor$SE
SE
traitNames <- paste("Disease", 1:10, sep = "")
SNP1 <- "rs1234"
result <- cpbayes_uncor(BetaHat, SE, Phenotypes = traitNames, Variant = SNP1)
PleioSumm <- post_summaries(result, level = 0.05) 
str(PleioSumm)

}
\references{
Arunabha Majumdar, Tanushree Haldar, Sourabh Bhattacharya, John Witte.
 An efficient Bayesian meta-analysis 
 approach for studying cross-phenotype genetic associations (submitted). Available
 at: http://biorxiv.org/content/early/2017/01/18/101543.
}
\seealso{
\code{\link{cpbayes_uncor}}, \code{\link{cpbayes_cor}}, \code{\link{estimate_corln}}
}

