% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corln_estimation.R
\name{estimate_corln}
\alias{estimate_corln}
\title{Estimate correlation structure of beta-hat vector for multiple overlapping case-control studies
or a cohort study using sample-overlap matrix.}
\usage{
estimate_corln(n11, n00, n10)
}
\arguments{
\item{n11}{An integer square matrix (number of rows must be the same as the number of
studies/traits) providing the
number of cases shared between all possible pairs of studies/traits. So (k,l)-th element of n11
is the number of subjects who are case for both k-th and l-th study/trait. Note that the diagonal elements of
n11 are the number of cases across studies/traits. In case, no case is shared between studies/traits,
the off-diagonal elements of n11 will be zero. No default is specified.}

\item{n00}{An integer square matrix (number of rows must be the same as the
number of studies/traits) providing the
number of controls shared between all possible pairs of studies/traits. So (k,l)-th element of n00
is the number subjects who are control for both k-th and l-th study/trait. Note that the diagonal
elements of n00 are the number of controls across studies/traits. In case, no control is
 shared between studies/traits,
the off-diagonal elements will be zero. No default is specified.}

\item{n10}{An integer square matrix (number of rows must be the same as the
 number of studies/traits) providing the
number of subjects who are case for one study/trait and control for another study/trait.
 Clearly, the diagonal elements 
will be zero. An off diagonal element, e.g., (k,l)-th element of n10 is the number of subjects who
are case for k-th study/trait and control for l-th study/trait. If there is no such overlap,
all the elements
of n10 will be zero. No default is specified.}
}
\value{
This function returns an approximate correlation matrix of the beta-hat vector for 
multiple overlapping case-control studies or a cohort study. See the example below.
}
\description{
Compute an approximate correlation matrix of the beta-hat vector for multiple overlapping
 case-control studies or a cohort study using the sample-overlap matrices which describe
the number of cases or controls shared between studies/traits, and the number of subjects
who are case for one study/trait but control for another study/trait. This approximation is more accurate
when none of the diseases/traits is associated with the environmental covariates present in the study.
  
***Important note on the estimation of correlation structure of correlated beta-hat vector:***
In general, environmental covariates are expected to be present in a study and associated
with the phenotypes of interest. Hence the above approximation of the correlation matrix
may not be completely accurate. So, in presence of environmental covariates, we recommend
an alternative strategy to estimate the correlation matrix using the genome-wide summary
statistics data across traits as follows. First, extract all the SNPs for each of which the
trait-specific univariate association p-value across all the traits are > 0.1. The
trait-specific univariate association p-values can be obtained based on the beta-hat
and standard error for each trait. Each of the SNPs selected in this way is either weakly
or not associated with any of the phenotypes (null SNP). Next, select a set of independent
null SNPs from the initial set of null SNPs by using a threshold of r^2 < 0.01 (r: the 
correlation between the genotypes at a pair of SNPs). Finally, compute the correlation
matrix of the effect estimates (beta-hat vector) as the sample correlation matrix of the
beta-hat vector across all the selected independent null SNPs. This strategy is more
general and applicable to a cohort study or multiple overlapping studies for binary or
quantitative traits with arbitrary distributions. Misspecification of the correlation
structure can affect the results produced by CPBayes to some extent. Hence, if 
genome-wide summary statistics data across traits is available, we recommend to use
this alternative strategy to estimate the correlation matrix of the beta-hat vector.
See our paper for more details at:  http://biorxiv.org/content/early/2017/01/18/101543.
}
\examples{
data(SampleOverlapMatrix)
n11 <- SampleOverlapMatrix$n11
n11
n00 <- SampleOverlapMatrix$n00
n00
n10 <- SampleOverlapMatrix$n10
n10
cor <- estimate_corln(n11, n00, n10)
cor

}
\references{
Arunabha Majumdar, Tanushree Haldar, Sourabh Bhattacharya, John Witte.
 An efficient Bayesian meta-analysis 
 approach for studying cross-phenotype genetic associations (submitted). Available
 at: http://biorxiv.org/content/early/2017/01/18/101543.
}
\seealso{
\code{\link{cpbayes_cor}}
}

