% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ExampleDataUncor}
\alias{ExampleDataUncor}
\title{An example data for uncorrelated summary statistics.}
\format{A list of two numeric vectors each of length 10 (for 10 studies):
\describe{
    \item{BetaHat}{beta hat vector of length 10.}
    \item{SE}{standard error vector corresponding to beta-hat vector.}
}}
\usage{
data(ExampleDataUncor)
}
\description{
ExampleDataUncor is a list which has two components: BetaHat, SE. The numeric vector 
ExampleDataUncor$BetaHat contains the main genetic effect (beta/log(odds ratio)) estimates
for a single nucleotide polymorphism (SNP) obtained from 10 separate case-control studies
for 10 different diseases. In each case-control study comprising a
distinct set of 7000 cases and 10000 controls, we fit a logistic regression
of the case-control status on the genotype coded as the minor allele count
for all the individuals in the sample. One can also include various covariates,
such as, age, gender, principal components (PCs) of ancestries in the logistic regression.
From each logistic regression for a
disease, we obtain the estimate of the main genetic association parameter
(beta/log(odds ratio)) along with the corresponding standard error.
Since the studies do not have any overlapping subject, the beta-hat across the traits are uncorrelated.
ExampleDataUncor$SE is the second numeric vector that contains the standard errors corresponding to
the uncorrelated beta-hat vector.
}
\examples{
data(ExampleDataUncor)
BetaHat <- ExampleDataUncor$BetaHat
BetaHat
SE <- ExampleDataUncor$SE
SE
\donttest{cpbayes_uncor(BetaHat, SE)}
}
\keyword{datasets}

