#include <math.h>
#include <float.h>

#include "general.h"
#include "error.h"
#include "dataStore.h"
#include "ftree.h"
#include "regtree.h"
#include "utils.h"
#include "binnode.h"
#include "binnodeReg.h"

#if defined(R_PORT)
SEXP featureTree::T2Rpart()
{
        int nProtected = 0;
        /*
         * number of leaf node TODO: try noLeaves if present-it is the same
         */
        int treeDepth = this->getSize(this->root);
        /*
         * all nodes (leaf + inner node - binary tree!)
         */
        int line = 2*treeDepth-1;

        /*
         * frame data
         */
        const int varNames = 9;
        int varRealName = varNames-1;
        SEXP outMatrix;
        PROTECT(outMatrix = allocVector(VECSXP, line*varRealName));
        nProtected++;
        /*
         * frame names
         */
        SEXP outVector;
        PROTECT(outVector = allocVector(STRSXP, varNames));
        nProtected++;
        /*
         * two colons [sequential index, attribute index]
         */
        SEXP outVectorLabels;
        PROTECT(outVectorLabels = allocVector(STRSXP, line*3));
        nProtected++;

        //frame names
        SET_STRING_ELT(outVector, 0, mkChar("var"));
        SET_STRING_ELT(outVector, 1, mkChar("n"));
        SET_STRING_ELT(outVector, 2, mkChar("wt"));
        SET_STRING_ELT(outVector, 3, mkChar("dev"));
        SET_STRING_ELT(outVector, 4, mkChar("yval"));
        SET_STRING_ELT(outVector, 5, mkChar("complexity"));
        SET_STRING_ELT(outVector, 6, mkChar("ncompete"));
        SET_STRING_ELT(outVector, 7, mkChar("nsurrogate"));
        SET_STRING_ELT(outVector, 8, mkChar("yval2"));

        
        /*
         * constant number of column names in split table
         */
        const int splitsNames = 6;
        SEXP outSplitVector;
        PROTECT(outSplitVector = allocVector(STRSXP, splitsNames-1));
        nProtected++;

        /*
         * not leaf nodes. Only inner nodes have an entry in the split matrix
         */
        SEXP outSplitMatrix;
        PROTECT(outSplitMatrix = allocVector(VECSXP, (treeDepth-1)*splitsNames));
        nProtected++;

        //split names
        SET_STRING_ELT(outSplitVector, 0, mkChar("count"));
        SET_STRING_ELT(outSplitVector, 1, mkChar("ncat"));
        SET_STRING_ELT(outSplitVector, 2, mkChar("improve"));
        SET_STRING_ELT(outSplitVector, 3, mkChar("index"));
        SET_STRING_ELT(outSplitVector, 4, mkChar("adj"));
        
        /*
         * csplit array for discrete attributes.
         * rows: for each inner node == possible discrete split
         * column: max levels == max number of values of each attr.
         */
        int currCsplitMax = 0;
        for(int csplitColumn = 0; csplitColumn < this->AttrDesc.len(); csplitColumn++){
                if(currCsplitMax < this->AttrDesc[csplitColumn].NoValues){
                        currCsplitMax = this->AttrDesc[csplitColumn].NoValues;
                }
        }
        /*
         * internal nodes 2*x-1-x = x-1
         * x == all leaf nodes
         */
        const int csplitArrayLen = (treeDepth-1)*currCsplitMax;
        SEXP csplitArray;
        PROTECT(csplitArray = allocVector(INTSXP, csplitArrayLen));
        nProtected++;
        /*
         * initialize csplit array to 3.
         * 1 is attr. goes to the left
         * 2 not in the split
         * 3 is attr. goes to the right
         * Later we will set it to 1/3 if attr-value is present in the tree
         */
        for(int initCsplit=0; initCsplit < csplitArrayLen; initCsplit++){
                INTEGER(csplitArray)[initCsplit] = 2;
        }
        
        /*
         * current position in csplit table
         */
        int csplitIndex = 1;

        
        /*
         * two columns for each attribute
         * 1. discrete index of current attribute
         * 2. current attribute name
         */
        const int attributeLabelsColumn = 2;
        int attrLabelsSize = attributeLabelsColumn*(treeDepth-1);
        SEXP attributeLabels;
        PROTECT(attributeLabels = allocVector(STRSXP, attrLabelsSize));
        nProtected++;

        /*
         * final function output
         */
        SEXP out;
        PROTECT(out = allocVector(VECSXP, 14));
        nProtected++;

        /*
         * auxiliary variables
         */
        SEXP aux;
        PROTECT(aux = allocVector(REALSXP, 1));
        nProtected++;

        SEXP auxLen;
        PROTECT(auxLen = allocVector(INTSXP, 1));
        nProtected++;

        
        /*
         * example distribution per node
         */
        SEXP exampleDistr;
        PROTECT(exampleDistr = allocVector(REALSXP, line*noClasses));
        nProtected++;

        Pbinnode *aIntNode = new Pbinnode[line];

        int *aIntLabel = new int[line];

        binnode *aNode = this->root;

        aIntNode[0] = aNode;
        aIntNode[1] = NULL;
        aIntLabel[0] = 1;

        int addedCount = 1;
        int noLeafCount = -1;
        int noAttributeCount = -1;
        char aStr[128];
        bool nodeChanged;
        for(int i =0; i < line; i++){
                aNode = aIntNode[i];
                nodeChanged = FALSE;
                //n, wt
                aux = allocVector(REALSXP, 1);
                REAL(aux)[0] = aNode->weight;
                SET_VECTOR_ELT(outMatrix, i*varRealName, aux);
                SET_VECTOR_ELT(outMatrix, i*varRealName+1, aux);
                //dev
                aux = allocVector(REALSXP, 1);
                double deviation = 0;
                double deviationPerClass = 0.0;
                for(int k = 1; k <= noClasses; k++){
                        deviationPerClass = aNode->Classify[k];
                        if(aNode->majorClass != k)
                        {
                                        deviation += deviationPerClass;
                        }
                        REAL(exampleDistr)[i*noClasses+(k-1)] = (int)(deviationPerClass);
                }
                REAL(aux)[0] = (int)(deviation);
                SET_VECTOR_ELT(outMatrix, i*varRealName+2, aux);
                //yval, yval2
                aux = allocVector(REALSXP, 1);
                int classValue = aNode->majorClass;
                REAL(aux)[0] = classValue;
                SET_VECTOR_ELT(outMatrix, i*varRealName+3, aux);
                SET_VECTOR_ELT(outMatrix, i*varRealName+7, aux);
                //complexity
                aux = allocVector(REALSXP, 1);
                REAL(aux)[0] = 0.5;
                SET_VECTOR_ELT(outMatrix, i*varRealName+4, aux);
                if(aNode->Identification != leaf){
                        if(aNode->left != NULL){
                                addedCount = i+1;
                                aIntNode[addedCount] = aNode->left;
                                aIntLabel[addedCount] = 2*aIntLabel[i]+0;
                                addedCount++;
                                
                        }
                        if(aNode->right != NULL){
                                /*
                                 * between the left and right node we need space
                                 * for the entire left subtree:
                                 * 1+(2*n-1), n is the number of leaf node
                         */
                                addedCount = i+2*this->getSize(aNode->left);
                                aIntNode[addedCount] = aNode->right;
                                aIntLabel[addedCount] = 2*aIntLabel[i]+1;
                                addedCount++;
                                
                        }
                        /*
                         * sequence index of a line
                         */
                        sprintf(aStr, "%d", aIntLabel[i]);
                        SET_STRING_ELT(outVectorLabels, i, mkChar(aStr));
                }
                else{
                        sprintf(aStr, "%d", aIntLabel[i]);
                        /*
                         * outVectorLabels must be of type STRSXP, 
                         * but sometimes it changes to CLOSXP - closure
                         */
                        SET_STRING_ELT(outVectorLabels, i, mkChar(aStr));
                        SET_STRING_ELT(outVectorLabels, i+line, mkChar("<leaf>"));
                        char *desc = aNode->Model.descriptionString();
                        SET_STRING_ELT(outVectorLabels, i+2*line, mkChar(desc));
                }
                /*
                 * ncompete, nsurrogate
                 * because odfcumsum and !is.leaf in labels.rpart
                 */
                aux = allocVector(REALSXP, 1);
                REAL(aux)[0] = 0;
                SET_VECTOR_ELT(outMatrix, i*varRealName+5, aux);
                SET_VECTOR_ELT(outMatrix, i*varRealName+6, aux);
                if(aNode->Identification != leaf){
                        noLeafCount++;
                        /*
                         * splits:count
                         */
                        int atPos = noLeafCount*splitsNames+1;
                        aux = allocVector(REALSXP, 1);
                        REAL(aux)[0] = aNode->left->weight;
                        SET_VECTOR_ELT(outSplitMatrix, atPos, aux);
                }

                attribute *anAttribute = NULL;
                int anAttributeIndex = -1;
                if(aNode->Identification == continuousAttribute){
                        anAttributeIndex = this->ContIdx[aNode->Construct.root->attrIdx];
                        anAttribute = &this->AttrDesc[anAttributeIndex];

                        /*
                         * splits:"ncat"
                         */
                        int atPos = noLeafCount*splitsNames;
                        int direction = -1;
                        if(nodeChanged == TRUE){
                                direction = 1;
                        }
                        aux = allocVector(REALSXP, 1);
                        REAL(aux)[0] = direction;
                        SET_VECTOR_ELT(outSplitMatrix, atPos+2, aux);
                        /*
                         * splits:"improve, adj"
                         */
                        aux = allocVector(REALSXP, 1);
                        REAL(aux)[0] = 0;
                        SET_VECTOR_ELT(outSplitMatrix, atPos+3, aux);
                        SET_VECTOR_ELT(outSplitMatrix, atPos+5, aux);
                        /*
                         * splits:"index"
                         */
                        aux = allocVector(REALSXP, 1);
                        REAL(aux)[0] = aNode->Construct.splitValue;
                        SET_VECTOR_ELT(outSplitMatrix, atPos+4, aux);
                }
                if(aNode->Identification == discreteAttribute){
                        anAttributeIndex = this->DiscIdx[aNode->Construct.root->attrIdx];
                        anAttribute = &this->AttrDesc[anAttributeIndex];

                        //splits:"ncat"
                        int atPos = noLeafCount*splitsNames;
                        aux = allocVector(REALSXP, 1);
                        REAL(aux)[0] = anAttribute->NoValues;
                        SET_VECTOR_ELT(outSplitMatrix, atPos+2, aux);

                        //splits:"improve, adj"
                        aux = allocVector(REALSXP, 1);
                        REAL(aux)[0] = 0;
                        SET_VECTOR_ELT(outSplitMatrix, atPos+3, aux);
                        SET_VECTOR_ELT(outSplitMatrix, atPos+5, aux);

                        //splits:"index, to je index v csplit tabeli!"
                        aux = allocVector(REALSXP, 1);
                        REAL(aux)[0] = csplitIndex;
                        SET_VECTOR_ELT(outSplitMatrix, atPos+4, aux);
                        //csplit index
                        int csplitCurrentColumn = (csplitIndex-1)*currCsplitMax;

                        int leftValue = 1;
                        int rigthValue = 3;
                        if(nodeChanged == TRUE){
                                leftValue = 3;
                                rigthValue = 1;
                        }
                        /*
                         * no idea why aValue+1
                         */
                        for(int aValue=0; aValue < aNode->Construct.leftValues.len(); aValue++){
                                int atPos = csplitCurrentColumn+aValue;
                                if(aNode->Construct.leftValues[aValue+1] == mTRUE){
                                        INTEGER(csplitArray)[atPos] = leftValue;
                                }
                                else{
                                        /*
                                         * if not in left values than it must be in the right
                                         */
                                        INTEGER(csplitArray)[atPos] = rigthValue;
                                }
                        }
                        
                        csplitIndex++;
                }
                /*
                 * if not a leaf add it.
                 */
                if(anAttribute != NULL){
                        /*
                         * var line
                         */
                        sprintf(aStr, "%d", anAttributeIndex);
                        SET_STRING_ELT(outVectorLabels, i+line, mkChar(aStr));
                        /*
                         * splits:"id"
                         */
                        int atPos = noLeafCount*splitsNames;
                        auxLen = allocVector(INTSXP, 1);
                        INTEGER(auxLen)[0] = anAttributeIndex;
                        SET_VECTOR_ELT(outSplitMatrix, atPos, auxLen);

                        noAttributeCount++;
                        sprintf(aStr, "%d", anAttributeIndex);
                        SET_STRING_ELT(attributeLabels, noAttributeCount*2, mkChar(aStr));
                        sprintf(aStr, "%s", anAttribute->AttributeName);
                        SET_STRING_ELT(attributeLabels, noAttributeCount*2+1, mkChar(aStr));
                }
        }
        SET_VECTOR_ELT(out, 0, outMatrix);
        SET_VECTOR_ELT(out, 1, outVector);
        SET_VECTOR_ELT(out, 2, outVectorLabels);
        SET_VECTOR_ELT(out, 5, outSplitMatrix);
        SET_VECTOR_ELT(out, 6, outSplitVector);
        SET_VECTOR_ELT(out, 9, csplitArray);
        SET_VECTOR_ELT(out, 11, attributeLabels);
        

        auxLen = allocVector(INTSXP, 1);
        INTEGER(auxLen)[0] = line;
        SET_VECTOR_ELT(out, 3, auxLen);
        auxLen = allocVector(INTSXP, 1);
        INTEGER(auxLen)[0] = varNames-1;
        SET_VECTOR_ELT(out, 4, auxLen);
        auxLen = allocVector(INTSXP, 1);
        INTEGER(auxLen)[0] = treeDepth-1;
        SET_VECTOR_ELT(out, 7, auxLen);
        auxLen = allocVector(INTSXP, 1);
        INTEGER(auxLen)[0] = splitsNames;
        SET_VECTOR_ELT(out, 8, auxLen);
        auxLen = allocVector(INTSXP, 1);
        INTEGER(auxLen)[0] = currCsplitMax;
        SET_VECTOR_ELT(out, 10, auxLen);
        auxLen = allocVector(INTSXP, 1);
        INTEGER(auxLen)[0] = attributeLabelsColumn;
        SET_VECTOR_ELT(out, 12, auxLen);

        
        
        SET_VECTOR_ELT(out, 13, exampleDistr);
        
        UNPROTECT(nProtected);
        delete [] aIntNode ;
        delete [] aIntLabel ;

        return out;
}
SEXP regressionTree::T2Rpart()
{
        int nProtected = 0;
        /*
         * number of leaf node TODO: try noLeaves if present-it is the same
         */
        int treeDepth = this->getSize(this->root);
        /*
         * all nodes (leaf + inner node - binary tree!)
         */
        int line = 2*treeDepth-1;

        /*
         * frame data, razlozi zakaj ne uporabljas matriko...
         */
        const int varNames = 9;
        int varRealName = varNames-1;
        SEXP outMatrix;
        PROTECT(outMatrix = allocVector(VECSXP, line*varRealName));
        nProtected++;
        /*
         * frame names
         */
        SEXP outVector;
        PROTECT(outVector = allocVector(STRSXP, varNames));
        nProtected++;
        /*
         * two colons [sequential index, attribute index]
         */
        SEXP outVectorLabels;
        PROTECT(outVectorLabels = allocVector(STRSXP, line*3));
        nProtected++;

        //frame names
        SET_STRING_ELT(outVector, 0, mkChar("var"));
        SET_STRING_ELT(outVector, 1, mkChar("n"));
        SET_STRING_ELT(outVector, 2, mkChar("wt"));
        SET_STRING_ELT(outVector, 3, mkChar("dev"));
        SET_STRING_ELT(outVector, 4, mkChar("yval"));
        SET_STRING_ELT(outVector, 5, mkChar("complexity"));
        SET_STRING_ELT(outVector, 6, mkChar("ncompete"));
        SET_STRING_ELT(outVector, 7, mkChar("nsurrogate"));
        SET_STRING_ELT(outVector, 8, mkChar("yval2"));

        
        /*
         * constant number of column names in split table
         */
        const int splitsNames = 6;
        SEXP outSplitVector;
        PROTECT(outSplitVector = allocVector(STRSXP, splitsNames-1));
        nProtected++;

        /*
         * not leaf nodes. Only inner nodes have an entry in the split matrix
         */
        SEXP outSplitMatrix;
        PROTECT(outSplitMatrix = allocVector(VECSXP, (treeDepth-1)*splitsNames));
        nProtected++;

        //split names
        SET_STRING_ELT(outSplitVector, 0, mkChar("count"));
        SET_STRING_ELT(outSplitVector, 1, mkChar("ncat"));
        SET_STRING_ELT(outSplitVector, 2, mkChar("improve"));
        SET_STRING_ELT(outSplitVector, 3, mkChar("index"));
        SET_STRING_ELT(outSplitVector, 4, mkChar("adj"));
        
        /*
         * csplit array for descrete attributes.
         * rows: for each inner node == possible discrete split
         * column: max levels == max number of values of each attr.
         */
        int currCsplitMax = 0;
        for(int csplitColumn = 0; csplitColumn < this->AttrDesc.len(); csplitColumn++){
                if(currCsplitMax < this->AttrDesc[csplitColumn].NoValues){
                        currCsplitMax = this->AttrDesc[csplitColumn].NoValues;
                }
        }
        /*
         * internal nodes 2*x-1-x = x-1
         * x == all leaf nodes
         */
        const int csplitArrayLen = (treeDepth-1)*currCsplitMax;
        SEXP csplitArray;
        PROTECT(csplitArray = allocVector(INTSXP, csplitArrayLen));
        nProtected++;
        /*
         * initailize csplit array to 3.
         * 1 is attr. goes to the left
         * 2 not in the split
         * 3 is attr. goes to the right
         * Later we will set it to 1/3 if attr-value is present in the tree
         */
        for(int initCsplit=0; initCsplit < csplitArrayLen; initCsplit++){
                INTEGER(csplitArray)[initCsplit] = 2;
        }
        
        /*
         * current position in csplit table
         */
        int csplitIndex = 1;

        
        /*
         * two columns for each attribute
         * 1. discrete index of current attribute
         * 2. current attribute name
         */
        const int attributeLabelsColumn = 2;
        int attrLabelsSize = attributeLabelsColumn*(treeDepth-1);
        SEXP attributeLabels;
        PROTECT(attributeLabels = allocVector(STRSXP, attrLabelsSize));
        nProtected++;

        /*
         * final function output
         */
        SEXP out;
        PROTECT(out = allocVector(VECSXP, 14));
        nProtected++;

        /*
         * auxeliary variables
         */
        SEXP aux;
        PROTECT(aux = allocVector(REALSXP, 1));
        nProtected++;

        SEXP auxLen;
        PROTECT(auxLen = allocVector(INTSXP, 1));
        nProtected++;

        PbinnodeReg *aIntNode = new PbinnodeReg[line];
        int *aIntLabel = new int[line];

        binnodeReg *aNode = this->root;

        aIntNode[0] = aNode;
        aIntNode[1] = NULL;
        aIntLabel[0] = 1;

        int addedCount = 1;
        int noLeafCount = -1;
        int noAttributeCount = -1;
        char aStr[128];
        bool nodeChanged;
        for(int i =0; i < line; i++){
                aNode = aIntNode[i];
                nodeChanged = FALSE;
                //n, wt
                aux = allocVector(REALSXP, 1);
                REAL(aux)[0] = aNode->weight;
                SET_VECTOR_ELT(outMatrix, i*varRealName, aux);
                SET_VECTOR_ELT(outMatrix, i*varRealName+1, aux);
                //dev
                aux = allocVector(REALSXP, 1);
                double deviation = 0;
                deviation = aNode->MSE;
                REAL(aux)[0] = (int)(deviation);
                SET_VECTOR_ELT(outMatrix, i*varRealName+2, aux);
                //yval, yval2
                aux = allocVector(REALSXP, 1);
                double classValue = aNode->averageClassValue;
                REAL(aux)[0] = classValue;
                SET_VECTOR_ELT(outMatrix, i*varRealName+3, aux);
                SET_VECTOR_ELT(outMatrix, i*varRealName+7, aux);
                //complexity
                aux = allocVector(REALSXP, 1);
                REAL(aux)[0] = 0.5;
                SET_VECTOR_ELT(outMatrix, i*varRealName+4, aux);
                if(aNode->Identification != leaf){
                        if(aNode->left != NULL){
                                addedCount = i+1;
                                aIntNode[addedCount] = aNode->left;
                                aIntLabel[addedCount] = 2*aIntLabel[i]+0;
                                addedCount++;
                                
                        }
                        if(aNode->right != NULL){
                                /*
                                 * between the left and right node we need space
                                 * for the entire left subtree:
                                 * 1+(2*n-1), n is the number of leaf node
                         */
                                addedCount = i+2*this->getSize(aNode->left);
                                aIntNode[addedCount] = aNode->right;
                                aIntLabel[addedCount] = 2*aIntLabel[i]+1;
                                addedCount++;
                                
                        }
                        /*
                         * sequence index of a line
                         */
                        sprintf(aStr, "%d", aIntLabel[i]);
                        SET_STRING_ELT(outVectorLabels, i, mkChar(aStr));
                }
                else{
                        sprintf(aStr, "%d", aIntLabel[i]);
                        /*
                         * outVectorLabels must be of type STRSXP, 
                         * but sometimes it changes to CLOSXP - closure
                         */
                        SET_STRING_ELT(outVectorLabels, i, mkChar(aStr));
                        SET_STRING_ELT(outVectorLabels, i+line, mkChar("<leaf>"));
                        char *desc = aNode->Model.descriptionString();
                        SET_STRING_ELT(outVectorLabels, i+2*line, mkChar(desc));
                }
                /*
                 * ncompete, nsurrogate
                 * because odfcumsum and !is.leaf in labels.rpart
                 */
                aux = allocVector(REALSXP, 1);
                REAL(aux)[0] = 0;
                SET_VECTOR_ELT(outMatrix, i*varRealName+5, aux);
                SET_VECTOR_ELT(outMatrix, i*varRealName+6, aux);
                if(aNode->Identification != leaf){
                        noLeafCount++;
                        /*
                         * splits:count
                         */
                        int atPos = noLeafCount*splitsNames+1;
                        aux = allocVector(REALSXP, 1);
                        REAL(aux)[0] = aNode->left->weight;
                        SET_VECTOR_ELT(outSplitMatrix, atPos, aux);
                }

                attribute *anAttribute = NULL;
                int anAttributeIndex = -1;
                if(aNode->Identification == continuousAttribute){
                        anAttributeIndex = this->ContIdx[aNode->Construct.root->attrIdx];
                        anAttribute = &this->AttrDesc[anAttributeIndex];

                        /*
                         * splits:"ncat"
                         */
                        int atPos = noLeafCount*splitsNames;
                        int direction = -1;
                        if(nodeChanged == TRUE){
                                direction = 1;
                        }
                        aux = allocVector(REALSXP, 1);
                        REAL(aux)[0] = direction;
                        SET_VECTOR_ELT(outSplitMatrix, atPos+2, aux);
                        /*
                         * splits:"improve, adj"
                         */
                        aux = allocVector(REALSXP, 1);
                        REAL(aux)[0] = 0;
                        SET_VECTOR_ELT(outSplitMatrix, atPos+3, aux);
                        SET_VECTOR_ELT(outSplitMatrix, atPos+5, aux);
                        /*
                         * splits:"index"
                         */
                        aux = allocVector(REALSXP, 1);
                        REAL(aux)[0] = aNode->Construct.splitValue;
                        SET_VECTOR_ELT(outSplitMatrix, atPos+4, aux);
                }
                if(aNode->Identification == discreteAttribute){
                        anAttributeIndex = this->DiscIdx[aNode->Construct.root->attrIdx];
                        anAttribute = &this->AttrDesc[anAttributeIndex];

                        //splits:"ncat"
                        int atPos = noLeafCount*splitsNames;
                        aux = allocVector(REALSXP, 1);
                        REAL(aux)[0] = anAttribute->NoValues;
                        SET_VECTOR_ELT(outSplitMatrix, atPos+2, aux);

                        //splits:"improve, adj"
                        aux = allocVector(REALSXP, 1);
                        REAL(aux)[0] = 0;
                        SET_VECTOR_ELT(outSplitMatrix, atPos+3, aux);
                        SET_VECTOR_ELT(outSplitMatrix, atPos+5, aux);

                        //splits:"index, to je index v csplit tabeli!"
                        aux = allocVector(REALSXP, 1);
                        REAL(aux)[0] = csplitIndex;
                        SET_VECTOR_ELT(outSplitMatrix, atPos+4, aux);
                        //csplit index
                        int csplitCurrentColumn = (csplitIndex-1)*currCsplitMax;

                        int leftValue = 1;
                        int rigthValue = 3;
                        if(nodeChanged == TRUE){
                                leftValue = 3;
                                rigthValue = 1;
                        }
                        /*
                         * no idea why aValue+1
                         */
                        for(int aValue=0; aValue < aNode->Construct.leftValues.len(); aValue++){
                                int atPos = csplitCurrentColumn+aValue;
                                if(aNode->Construct.leftValues[aValue+1] == mTRUE){
                                        INTEGER(csplitArray)[atPos] = leftValue;
                                }
                                else{
                                        /*
                                         * if not in left values than it must be in the right
                                         */
                                        INTEGER(csplitArray)[atPos] = rigthValue;
                                }
                        }
                        
                        csplitIndex++;
                }
                /*
                 * if not a leaf add it.
                 */
                if(anAttribute != NULL){
                        /*
                         * var line
                         */
                        sprintf(aStr, "%d", anAttributeIndex);
                        SET_STRING_ELT(outVectorLabels, i+line, mkChar(aStr));
                        /*
                         * splits:"id"
                         */
                        int atPos = noLeafCount*splitsNames;
                        auxLen = allocVector(INTSXP, 1);
                        INTEGER(auxLen)[0] = anAttributeIndex;
                        SET_VECTOR_ELT(outSplitMatrix, atPos, auxLen);

                        noAttributeCount++;
                        sprintf(aStr, "%d", anAttributeIndex);
                        SET_STRING_ELT(attributeLabels, noAttributeCount*2, mkChar(aStr));
                        sprintf(aStr, "%s", anAttribute->AttributeName);
                        SET_STRING_ELT(attributeLabels, noAttributeCount*2+1, mkChar(aStr));
                }
        }
        SET_VECTOR_ELT(out, 0, outMatrix);
        SET_VECTOR_ELT(out, 1, outVector);
        SET_VECTOR_ELT(out, 2, outVectorLabels);
        SET_VECTOR_ELT(out, 5, outSplitMatrix);
        SET_VECTOR_ELT(out, 6, outSplitVector);
        SET_VECTOR_ELT(out, 9, csplitArray);
        SET_VECTOR_ELT(out, 11, attributeLabels);
        

        auxLen = allocVector(INTSXP, 1);
        INTEGER(auxLen)[0] = line;
        SET_VECTOR_ELT(out, 3, auxLen);
        auxLen = allocVector(INTSXP, 1);
        INTEGER(auxLen)[0] = varNames-1;
        SET_VECTOR_ELT(out, 4, auxLen);
        auxLen = allocVector(INTSXP, 1);
        INTEGER(auxLen)[0] = treeDepth-1;
        SET_VECTOR_ELT(out, 7, auxLen);
        auxLen = allocVector(INTSXP, 1);
        INTEGER(auxLen)[0] = splitsNames;
        SET_VECTOR_ELT(out, 8, auxLen);
        auxLen = allocVector(INTSXP, 1);
        INTEGER(auxLen)[0] = currCsplitMax;
        SET_VECTOR_ELT(out, 10, auxLen);
        auxLen = allocVector(INTSXP, 1);
        INTEGER(auxLen)[0] = attributeLabelsColumn;
        SET_VECTOR_ELT(out, 12, auxLen);

        
        UNPROTECT(nProtected);
        delete [] aIntNode ;
        delete [] aIntLabel ;

        return out;
}
SEXP featureTree::proximity(bool distance)
{
        int nProtected = 0;

        SEXP out;
        PROTECT(out = allocMatrix(REALSXP, NoCases, NoCases));
        nProtected++;

        marray<IntSortRec> near(NoCases) ;
        //   use Breiman's proximity measure:
        //   number of trees where instances are in the same leaf
        marray<double> distr(noClasses+1) ;
        for(int caseIdx = 0; caseIdx < NoCases; caseIdx++){
                for (int i=0 ; i < NoCases ; i++){
                        near[i].key = 0 ;
                        near[i].value = i ;
                }
                for (int iT=0 ; iT < opt->rfNoTrees ; iT++){
                        rfFindNearInTree(forest[iT].t.root, caseIdx, near) ;
                }
                for (int i=0 ; i < NoCases ; i++){
                        if(caseIdx == i){
                                /*
                                 * diagonal is 1
                                 */
                                double diag = 1.0;
                                if(distance){
                                        diag = 0.0;
                                }
                                REAL(out)[caseIdx*(NoCases+1)] = diag;
                        }
                        else{
                                REAL(out)[caseIdx*NoCases+i] = near[i].key/ 2.0 / opt->rfNoTrees;
                        }
                }
        }
        /*
         * we need a symmetric matrix
         */
        double aValue = 0.0;
        for (int i=0 ; i < NoCases*NoCases ; i++){
                /*
                 * out[a,b]
                 */
                int a = i % NoCases;
                int b = (int)i/NoCases;
                if(a > b){
                        aValue = (REAL(out)[b*NoCases+a] + REAL(out)[a*NoCases+b])/2;
                        if(distance){
                                aValue = sqrt(1-aValue);
                        }
                        REAL(out)[b*NoCases+a] = aValue;
                        REAL(out)[a*NoCases+b] = aValue;
                }
        }
        UNPROTECT(nProtected);
        return out;
}
#endif
int regressionTree::getSize(binnodeReg *branch)
{
        if (branch->Identification==leaf)
                return 1;
        else
                return (getSize(branch->left) + getSize(branch->right));
}
void featureTree::oobEvaluateCluster(mmatrix<int> &oob, marray<booleanT> &cluster)
{
   marray<double> distr(noClasses+1) ;
   int iT, i, max ;
   oob.init(0) ;
   for (iT = 0 ; iT < opt->rfNoTrees ; iT++){
         for (i=0 ; i < NoTrainCases ; i++)
                if (cluster[i] && forest[iT].oob[i]){
                        max = rfTreeCheck(forest[iT].t.root, DTraining[i], distr) ;
                        oob(i, max)++ ;
                }
   }
}
void featureTree::varImportanceCluster(marray<double> &varEval, marray<booleanT> &cluster){
    marray<int> discOrig(NoCases), discTemp(NoCases) ;
        marray<double> contOrig(NoCases), contTemp(NoCases) ;
        discOrig.setFilled(NoCases) ;
        discTemp.setFilled(NoCases) ;
        contOrig.setFilled(NoCases) ;
        contTemp.setFilled(NoCases) ;
        mmatrix<int> oob(NoTrainCases, noClasses+1) ;
    marray<int> maxOther(NoTrainCases) ; // dummy placeholder
    double varMargin ; // dummy placeholder
        for (int iA = 1 ; iA <= noAttr ; iA++) {
                if (AttrDesc[iA].continuous) {
                // save original values of instances and reschuffle it
                        NumData.outColumn(AttrDesc[iA].tablePlace, contOrig);
                        contTemp.copy(contOrig);
                        contTemp.shuffle();
                        NumData.inColumn(contTemp, AttrDesc[iA].tablePlace);
                }
                else {
                        DiscData.outColumn(AttrDesc[iA].tablePlace, discOrig);
                        discTemp.copy(discOrig);
                        discTemp.shuffle();
                        DiscData.inColumn(discTemp, AttrDesc[iA].tablePlace);
                }
            // compute margin
            oobEvaluateCluster(oob, cluster) ;
            varEval[iA-1] = avgOobMargin - oobMargin(oob, maxOther, varMargin) ;

                if (AttrDesc[iA].continuous)
                        NumData.inColumn(contOrig, AttrDesc[iA].tablePlace);
                else
                        DiscData.inColumn(discOrig, AttrDesc[iA].tablePlace);

        }
}
#if defined(R_PORT)
SEXP featureTree::importance2RCluster(marray<double> &varEval, marray<booleanT> &cluster)
{
        int nProtected = 0;

        SEXP out;
        PROTECT(out = allocVector(REALSXP, noAttr));
        nProtected++;

        varImportanceCluster(varEval, cluster);

        for (int i=1 ; i <= noAttr ; i++){
                REAL(out)[i-1] = varEval[i-1];
        }

        UNPROTECT(nProtected);
        return out;
}
#endif
