% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COMBIA.R
\name{readMacSynergyValues}
\alias{readMacSynergyValues}
\title{Read data from macsynergyII formate and clean for outliers}
\usage{
readMacSynergyValues(file, sheet, nrow = 41, wellRangesExcel,
  minThersholdForCVCal, minThersholdForCV, survivalFunc)
}
\arguments{
\item{file}{Name of fiele to be read}

\item{sheet}{Sheet Number}

\item{nrow}{Number of rows in the sheet}

\item{wellRangesExcel}{TRUE if wells in excel formate}

\item{minThersholdForCVCal}{Thresolld for data outliears in CV}

\item{minThersholdForCV}{Thresold of values in CV not to remove}

\item{survivalFunc}{<-  function (x,y,z) {(x-z)/(y-z)} # It can be any function}
}
\value{
Matrix of replicated values
}
\description{
Read data from macsynergyII formate and clean for outliers
}
\examples{
fl <- system.file("extdata", "testData.csv", package="COMBIA")
sh <- 1
wellR <- list(c( "l3:l10","m3:m10","b3:k10",  "l13:l20","m13:m20","b13:k20", 
           "l23:l30","m23:m30","b23:k30",  "l33:l40","m33:m40","b33:k40"))
minThersholdForCV <- 0.3
minThersholdForCVCal <- 0.1
survivalFunc <-  function (x,y,z) {(x-z)/(y-z)}
rslt <- readMacSynergyValues(fl, sh, nrow=41, wellR,  
minThersholdForCVCal, minThersholdForCV, survivalFunc)
}
\author{
Muhammad kashif
}
