% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_s3generics_clvfitted.R
\name{vcov.clv.fitted}
\alias{vcov.clv.fitted}
\title{Calculate Variance-Covariance Matrix for CLV Models fitted with Maximum Likelihood Estimation}
\usage{
\method{vcov}{clv.fitted}(object, ...)
}
\arguments{
\item{object}{a fitted clv model object}

\item{...}{Ignored}
}
\value{
A matrix of the estimated covariances between the parameters of the model.
The row and column names correspond to the parameter names given by the \code{coef} method.
}
\description{
Returns the variance-covariance matrix of the parameters of the fitted model object.
The variance-covariance matrix is derived from the Hessian that results from the optimization procedure.
First, the Moore–Penrose generalized inverse of the Hessian is used to obtain an estimate of the
variance-covariance matrix.
Next, because some parameters may be transformed for the purpose of restricting their value during
the log-likelihood estimation, the variance estimates are adapted to
be comparable to the reported coefficient estimates.
If the result is not positive definite, \link[Matrix:nearPD]{Matrix::nearPD} is used
with standard settings to find the nearest positive definite matrix.

If multiple estimation methods were used, the Hessian of the last method is used.
}
\seealso{
\link[MASS:ginv]{MASS::ginv}, \link[Matrix:nearPD]{Matrix::nearPD}
}
