% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CLONETv2_compute_snv_clonality.R
\name{compute_snv_clonality}
\alias{compute_snv_clonality}
\title{Function to compute clonality of SNVs}
\usage{
compute_snv_clonality(sample_id, snv_read_count, beta_table, ploidy_table,
  admixture_table, error_tb = error_table, error_rate = 0.05,
  n_digits = 3, n_cores = 1, annotation_style = "VEP", debug = F)
}
\arguments{
\item{sample_id}{the id of the analyzed sample. It must be the same value
reported in column sample of tables beta_table, ploidy_table, and
admixture_table}

\item{snv_read_count}{data.frame reporting in each row the genomic coordinates
of an SNV together with number of reference and alternative reads covering
the position in columns rc_ref_tumor and rc_alt_tumor, respectively. See
parameter annotation_style for details about column names}

\item{beta_table}{data.frame formatted as the output of function
\code{\link[CLONETv2:compute_beta_table]{compute_beta_table}}}

\item{ploidy_table}{data.frame formatted as the output of function
\code{\link[CLONETv2:compute_beta_table]{compute_ploidy}}}

\item{admixture_table}{data.frame formatted as the output of function
\code{\link[CLONETv2:compute_beta_table]{compute_dna_admixture}}}

\item{error_tb}{data.frame that reports for each combination of coverage and
number informative SNPs the expected estimation error around beta. The
data.frame error_tb must contains 3 columns: \describe{ \item{mean.cov}{mean
coverage} \item{n.info.snps}{number of informative SNPs}
\item{adm.estimation.error}{estimated error on computed beta on a segment
with coverage mean.cov and n.info.snps informative SNPs} } Package CLONETv2
have built in error_tb named error_table (default=error_table)}

\item{error_rate}{expected fraction of SNV positions with outlier variant
allelic fraction (default=0.05)}

\item{n_digits}{number of digits in the output table  (default=3)}

\item{n_cores}{number of cores (default=1)}

\item{annotation_style}{a string that corresponds to the format of the columns
that describe the genomic coordinates of a SNV. Accepted values are VEP and
MAF. \href{https://www.ensembl.org/info/docs/tools/vep/index.html}{VEP annotation}
describes genomic coordinates with a single column named Location. \href{https://docs.gdc.cancer.gov/Data/File_Formats/MAF_Format/}{MAF format} has
columns Chromosome, Start_position, and End_position for each aberrant
position}

\item{debug}{return extra columns for debugging (default=F)}
}
\value{
A data.frame that extends input table snv_read_count with columns
sample, cnA, cnB, t_af, t_af_corr, SNV.clonality, and SNV.clonality.status.
Columns cnA and cnB report the allele specific copy number of the genomic
segment containing the SNV position. Columns t_af and t_af_corr are
respectively raw and ploidy/purity adjusted tumor varian allelic fractions.
SNV.clonality reports the percentage of tumor cells harboring the SNV and
with allele specific copy number cnA and cnB. SNV.clonality.status column
lists dicretized SNV.clonality values. Discrete states are clonal,
uncertain.clonal, uncertain.subclonal, and subclonal based in threshold
automatically computed on the SNV.clonality values. Empty
SNV.clonality.status of an SNV indicates that clonality cannot be assessed.
}
\description{
This function takes as input the genomic position of a SNVs and computes the
percentage of genomic homogeneus cells harboring the mutation.
}
\examples{

## Compute SNVs clonality
snv_clonality_table_toy <- compute_snv_clonality("toy_sample",
  snv_reads_toy, bt_toy, pl_table_toy, adm_table_toy)

}
\author{
Davide Prandi, Tarcisio Fedrizzi
}
