% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postSumm.R
\name{postSumm}
\alias{postSumm}
\title{Summarize posterior samples}
\usage{
postSumm(RD_est, RR_est, OR_est)
}
\arguments{
\item{RD_est}{vector of estimation for RD}

\item{RR_est}{vector of estimation for RR}

\item{OR_est}{vector of estimation for OR}
}
\value{
list with 2 elements for ATT effect. It contains
\item{ATT12:}{A dataframe containing the estimation,
standard error, lower and upper 95\% CI for RD/RR/OR}
\item{ATT13:}{A dataframe containing the estimation,
standard error, lower and upper 95\% CI for RD/RR/OR}
list with 3 elements for ATE effect. It contains
\item{ATE12:}{A dataframe containing the estimation,
standard error, lower and upper 95\% CI for RD/RR/OR}
\item{ATE13:}{A dataframe containing the estimation,
standard error, lower and upper 95\% CI for RD/RR/OR}
\item{ATE23:}{A dataframe containing the estimation,
standard error, lower and upper 95\% CI for RD/RR/OR}
}
\description{
This function summarize posterior samples of RD, RR and OR. Please use our main function causal_multi_treat.R.
}
\examples{
library(CIMTx)
postSumm(RD_est = 1:10, RR_est = 11:20, OR_est = 1:10)
}
