% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_function.R
\name{summary.ciee}
\alias{summary.ciee}
\title{Summary function.}
\usage{
\method{summary}{ciee}(object = NULL, ...)
}
\arguments{
\item{object}{\code{ciee} object (output of the \code{\link{ciee}}
or \code{\link{ciee_loop}} function).}

\item{...}{Additional arguments affecting the summary produced.}
}
\value{
Formatted data frames of the results of all computed methods.
}
\description{
Summary function for the \code{\link{ciee}} and \code{\link{ciee_loop}}
functions.
}
\examples{

maf <- 0.2
n <- 1000
dat <- generate_data(n = n, maf = maf)
datX <- data.frame(X = dat$X)
names(datX)[1] <- "X1"
for (i in 2:10){
  X <- stats::rbinom(n, size = 2, prob = maf)
  datX$X <- X
  names(datX)[i] <- paste("X", i, sep="")
}

results1 <- ciee(Y = dat$Y, X = datX$X1, K = dat$K, L = dat$L)
summary(results1)

results2 <- ciee_loop(Y = dat$Y, X = datX, K = dat$K, L = dat$L)
summary(results2)

}
