% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindRationalStarts.R, R/plot.rstarts.R
\name{FindRationalStarts}
\alias{FindRationalStarts}
\alias{plot.rstarts}
\title{Plot method for rstarts object}
\usage{
FindRationalStarts(
  DataList,
  RatStarts = "all",
  nComp,
  nClus,
  scalevalue = NULL,
  center = TRUE,
  verbose = TRUE,
  pseudo = NULL,
  pseudoFac = NULL
)

\method{plot}{rstarts}(x, type = 1, mdsdim = 2, nClus = NULL, ...)
}
\arguments{
\item{DataList}{a list of matrices}

\item{RatStarts}{type of rational start. 'all' computes all types of hclust methods}

\item{nComp}{number of ICA components to extract}

\item{nClus}{Number of clusters for rectangles in dendrogram, default NULL is based on number of clusters present in the object}

\item{scalevalue}{scale each matrix to have an equal sum of squares}

\item{center}{mean center matrices}

\item{verbose}{print output to console}

\item{pseudo}{percentage value for perturbating rational starts to obtain pseudo rational starts}

\item{pseudoFac}{how many pseudo starts per rational start}

\item{x}{an object of \code{class} rstarts}

\item{type}{type of plot, 1 for a dendrogram, 2 for a multidimensional scaling configuration}

\item{mdsdim}{2 for two dimensional mds configuration, 3 for a three dimensional configuration}

\item{...}{optional arguments passed to \code{hclust} function}
}
\value{
dataframe with (pseudo-) rational and dist object based on the pairwise modified RV values
}
\description{
Two step clustering for finding rational start partitions
}
\examples{
\dontrun{
CICA_data <- Sim_CICA(Nr = 15, Q = 5, R = 4, voxels = 100, timepoints = 10,
E = 0.4, overlap = .25, externalscore = TRUE)
rats <- FindRationalStarts(DataList = CICA_data$X, nComp = 5, nClus = 4,verbose = TRUE, pseudo = .2)
plot(rats, type = 1, method = 'ward.D2')
plot(rats, type = 2, method = 'ward.D2')
plot(rats, type = 2, method = 'ward.D2', mdsdim = 3)
}


\dontrun{
CICA_data <- Sim_CICA(Nr = 15, Q = 5, R = 4, voxels = 100, timepoints = 10,
E = 0.4, overlap = .25, externalscore = TRUE)
Out_starts <- FindRationalStarts(DataList = CICA_data$X,nComp = 5,nClus = 4,scalevalue = 1000)
plot(Out_starts)
plot(Out_starts, type = 2)
plot(Out_starts, type = 2,mdsdim = 3, method = 'ward.D2')
}


}
\references{
Durieux, J., & Wilderjans, T. F. (2019). Partitioning subjects based on high-dimensional fMRI data: comparison of several clustering methods and studying the influence of ICA data reduction in big data. Behaviormetrika, 46(2), 271-311.
}
