% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init.EM.R
\name{init.EM}
\alias{init.EM}
\title{Initialization step of the \code{CHMM_EM} function.}
\usage{
init.EM(X, nb.states, meth.init, var.equal, nbI, nbT)
}
\arguments{
\item{X}{a matrix of observations. Columns correspond to series (individuals).}

\item{nb.states}{an integer specifying the numbers of states.}

\item{meth.init}{a string specifying the initialization method ("mclust" or "kmeans"). The default method is "mclust".}

\item{var.equal}{a logical variable indicating whether to treat the variances as being equal (TRUE, value by default) or not (FALSE).}

\item{nbI}{an integer specifying the number of series.}

\item{nbT}{an integer specifying the length of one series.}
}
\value{
A list of 6 objects.
\describe{
\item{\code{esAvgGb}}{ a matrix of \code{nbK}(nb.states^nbI) rows and \code{nbI} columns of estimated mean.}
\item{\code{esVarGb}}{ a matrix of \code{nbK}(nb.states^nbI) rows and \code{nbI} columns of estimated variance.}
\item{\code{esAvg}}{ a numeric of the estimated mean for each state.}
\item{\code{esVar}}{ a numeric of the estimated variance for each state.}
\item{\code{transGb}}{ a matrix of the state transition probabilities.}
\item{\code{initGb}}{ a numeric specifying the initial state probabilities.}
}
}
\description{
Initialization step of the \code{CHMM_EM} function.
}
\details{
By default, an initialization with the \code{meth.init="mclust"} is performed with homogeneous variances.
}
\seealso{
\code{\link{CHMM_EM}}
}
