% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seedist.R
\name{SeeDist}
\alias{SeeDist}
\title{See The Distribution}
\usage{
SeeDist(qqq, numbins = 0, whatvar = "Unspecified", whatplots = c("d", "b",
  "h"))
}
\arguments{
\item{qqq}{the data to be visualized must be numeric.}

\item{numbins}{the number of bins to use for any plots that bin. If nothing is
specified the function will calculate a rational number using Freedman-Diaconis
via the \code{nclass.FD} function}

\item{whatvar}{additional contextual information about the variable as a string
such as "Miles Per Gallon"}

\item{whatplots}{what type of plots?  The default is whatplots = c("d","b","h")
for a density, a boxplot, and a histogram}
}
\value{
from 1 to 3 plots depending on what the user specifies as well as a 
base R summary printed to the console
}
\description{
This function takes a vector of numeric data and returns one or more ggplot2
plots that help you visualize the data
}
\section{Warning}{

If the data has more than 3 modal values only the first three of them are plotted.
The rest are ignored and the user is warned on the console.

Missing values are removed with a warning to the user
}

\examples{
SeeDist(rnorm(100, mean=100, sd=20), numbins = 15, whatvar = "A Random Sample")
SeeDist(mtcars$hp, whatvar = "Horsepower")
SeeDist(iris$Sepal.Length, whatvar = "Sepal Length")

}
\seealso{
\code{\link[grDevices]{nclass}}
}
\author{
Chuck Powell
}
