% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CGGP_plot.R
\name{CGGPplottheta}
\alias{CGGPplottheta}
\title{Plot theta samples}
\usage{
CGGPplottheta(CGGP)
}
\arguments{
\item{CGGP}{CGGP object}
}
\value{
ggplot2 object
}
\description{
Plot theta samples
}
\examples{
gs <- CGGPcreate(d=3, batchsize=100)
f <- function(x){x[1]^1.2+x[3]^.4*sin(2*pi*x[2]^2*3) + .1*exp(3*x[3])}
y <- apply(gs$design, 1, f)
gs <- CGGPfit(gs, Y=y)
CGGPplottheta(gs)
}
\seealso{
Other CGGP plot functions: \code{\link{CGGPplotblocks}},
  \code{\link{CGGPplotcorr}}, \code{\link{CGGPplotheat}},
  \code{\link{CGGPplothist}},
  \code{\link{CGGPplotsamplesneglogpost}},
  \code{\link{CGGPplotslice}},
  \code{\link{CGGPplotvariogram}},
  \code{\link{CGGPvalplot}}
}
\concept{CGGP plot functions}
