% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CDFtestingSuite.R
\name{MSEanalytic}
\alias{MSEanalytic}
\title{Determine the expected MSE of a simple DPCDF from its parameters.}
\usage{
MSEanalytic(eps, range, gran, data, ...)
}
\arguments{
\item{eps}{Epsilon value for differential privacy control}

\item{range}{A vector length 2 containing user-specified min and max to
truncate the universe to}

\item{gran}{The smallest unit of measurement in the data (one [year]
for a list of ages)}

\item{data}{The vector of data from which the DP CDF was/is computed}

\item{...}{Optionally add additional parameters. This is primarily used to allow automated
execution of varied diagnostic functions.}
}
\value{
The MSE guaranteed by the given parameter combination assuming 
   it's built from 
   the min and max inward from a DP-Histogram, with 95% probability
}
\description{
Generates the analytically expected 
   Mean Squared Error of a dpCDF.
   introduced by random noise, SUPPOSING that the DP-CDF is through the use
   of a noisy binary tree.
}
\examples{
MSEanalytic(.01, c(1,10),1, rexp(10000,.4))
}

