% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{load_RBs}
\alias{load_RBs}
\title{Load CCAMLR Research Blocks}
\usage{
load_RBs()
}
\description{
Download the up-to-date spatial layer from the online CCAMLRGIS (\url{http://gis.ccamlr.org/}) and load it to your environment.
See examples for offline use. All layers use the Lambert azimuthal equal-area projection
 (\code{\link{CCAMLRp}})
}
\examples{
 
\donttest{

#When online:
RBs=load_RBs()
plot(st_geometry(RBs))

#If going offline in the future: load and save as RData when online,
#then reload RData when offline:
RBs=load_RBs()
EEZs=load_EEZs()
#N.B.: replace tempdir() with folder location of your choice
save(list=c('RBs','EEZs'), file = file.path(tempdir(), "CCAMLRLayers.RData"))
rm(RBs,EEZs)
load(file.path(tempdir(), "CCAMLRLayers.RData"))

}

}
\seealso{
\code{\link{load_ASDs}}, \code{\link{load_SSRUs}},
\code{\link{load_SSMUs}}, \code{\link{load_MAs}}, \code{\link{load_Coastline}},
\code{\link{load_MPAs}}, \code{\link{load_EEZs}}.
}
