% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CBDA_Stopping_Criteria.R
\name{CBDA_Stopping_Criteria}
\alias{CBDA_Stopping_Criteria}
\title{Stopping Criteria function for Compressive Big Data Analytics}
\usage{
CBDA_Stopping_Criteria(label = "CBDA_package_test", Kcol_min = 5,
  Kcol_max = 15, Nrow_min = 30, Nrow_max = 50, misValperc = 0,
  M = 3000, workspace_directory = tempdir(), max_covs = 100,
  min_covs = 5, lambda = 1.005)
}
\arguments{
\item{label}{This is the label appended to RData workspaces generated within the CBDA calls}

\item{Kcol_min}{Lower bound for the percentage of features-columns sampling (used for the Feature Sampling Range - FSR)}

\item{Kcol_max}{Upper bound for the percentage of features-columns sampling (used for the Feature Sampling Range - FSR)}

\item{Nrow_min}{Lower bound for the percentage of cases-rows sampling (used for the Case Sampling Range - CSR)}

\item{Nrow_max}{Upper bound for the percentage of cases-rows sampling (used for the Case Sampling Range - CSR)}

\item{misValperc}{Percentage of missing values to introduce in BigData (used just for testing, to mimic real cases).}

\item{M}{Number of the BigData subsets on which perform Knockoff Filtering and SuperLearner feature mining}

\item{workspace_directory}{Directory where the results and workspaces are saved}

\item{max_covs}{Top features to include in the Validation Step where nested models are tested}

\item{min_covs}{Minimum number of top features to include in the initial model for the Validation Step}

\item{lambda}{Fisher test threshold for MSE (=1.005 by default)}
}
\value{
value
}
\description{
This CBDA function generates a stopping criteria for the *max_covs - min_covs* nested
 predictive models generated in the previous step. It also populates the CBDA object.
}
