/*
 * Decompiled with CFR 0.152.
 */
package org.neptuneinc.cadstat.plots;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.neptuneinc.cadstat.ui.DataPlotDialog;
import org.neptuneinc.cadstat.utils.GUIUtils;
import org.neptuneinc.cadstat.utils.RUtils;
import org.rosuda.JGR.JGR;

public class RegressionPrediction
extends DataPlotDialog {
    private String modelString;
    private JPanel analysisOptionsPane;
    public JRadioButton binomDistButton;
    private JCheckBox browserResults;
    private JComboBox dependentComboBox;
    private JLabel dependentLabel;
    private ButtonGroup distButtonGroup;
    private JPanel distPane;
    private JPanel idPane;
    private JLabel idVarLabel;
    private JComboBox idVarList;
    private JLabel independentLabel;
    private JList independentList;
    private JScrollPane independentScrollPane;
    private JPanel modelEqPane;
    private JScrollPane modelEqScrollPane;
    private JTextArea modelEqTextArea;
    public JRadioButton normDistButton;
    private JPanel plotPane;
    public JRadioButton poisDistButton;
    private JCheckBox rmIntercept;
    private JComboBox sampleSizeComboBox;
    private JLabel sampleSizeLabel;
    private JPanel savePanel;
    private JLabel sigLabel;
    private JSpinner sigLevel;
    private JLabel siteIDLabel;
    private JList siteIDValList;
    private JScrollPane siteIDValScrollPane;
    private JPanel siteSelPane;
    private JLabel siteVarLabel;
    private JComboBox siteVarList;
    private JPanel varPane;

    protected void initCustom() {
        this.initComponents();
        this.getIdVarList().setModel(new DefaultComboBoxModel());
        this.getIdVarList().insertItemAt("", 0);
        this.getIdVarList().setSelectedIndex(0);
        this.getPlotPane().add((Component)this.plotPane, "Center");
        this.getDatasetPane().getDatasetComboBox().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RegressionPrediction.this.datasetComboBoxActionPerformed(e);
            }
        });
        this.refreshVariableList();
        this.refreshSiteVarList();
        this.refreshIdVarList();
        this.refreshValidity();
        this.updateModelEquation();
    }

    private void datasetComboBoxActionPerformed(ActionEvent e) {
        this.refreshVariableList();
        this.refreshSiteVarList();
        this.refreshIdVarList();
        this.refreshValidity();
        this.updateModelEquation();
    }

    public void refreshDistValidity() {
        Enumeration<AbstractButton> distButtonEnum = this.distButtonGroup.getElements();
        while (distButtonEnum.hasMoreElements()) {
            distButtonEnum.nextElement().setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0);
        }
    }

    public void refreshModelValidity() {
        this.refreshDistValidity();
        this.refreshVariableListValidity();
    }

    public void updateModelEquation() {
        if (this.getDatasetPane().getDatasetComboBox().getItemCount() > 0) {
            String modelEq = this.dependentComboBox.getSelectedItem() + " ~ " + RUtils.toString(this.independentList.getSelectedValues(), " + ", "");
            this.modelEqTextArea.setText(modelEq);
            if (this.binomDistButton.isSelected()) {
                this.setModelString(this.sampleSizeComboBox.getSelectedItem() + "," + this.dependentComboBox.getSelectedItem() + "," + RUtils.toString(this.independentList.getSelectedValues(), ",", ""));
            } else {
                this.setModelString(modelEq);
            }
        } else {
            this.setModelString(null);
            this.modelEqTextArea.setText(null);
        }
    }

    public void refreshVariableListValidity() {
        this.dependentLabel.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.dependentComboBox.getItemCount() > 0);
        this.dependentComboBox.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.dependentComboBox.getItemCount() > 0);
        this.independentLabel.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.independentList.getModel().getSize() > 0);
        this.independentList.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.independentList.getModel().getSize() > 0);
        this.sampleSizeLabel.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.sampleSizeComboBox.getItemCount() > 0 && this.binomDistButton.isSelected());
        this.sampleSizeComboBox.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.sampleSizeComboBox.getItemCount() > 0 && this.binomDistButton.isSelected());
        this.siteVarLabel.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.siteVarList.getItemCount() > 0);
        this.siteVarList.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.siteVarList.getItemCount() > 0);
        this.siteIDLabel.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.siteIDValList.getModel().getSize() > 0);
        this.siteIDValList.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.siteIDValList.getModel().getSize() > 0);
        this.idVarLabel.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.idVarList.getItemCount() > 0);
        this.idVarList.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.idVarList.getItemCount() > 0);
    }

    public void refreshVariableList() {
        if (this.getDatasetPane().getDatasetComboBox().getItemCount() > 0) {
            Vector nonFactors = RUtils.nonFactors(this.getDatasetPane().getSelectedDataset());
            Vector<String> onePlusNonFactors = new Vector<String>(nonFactors.size() + 1);
            onePlusNonFactors.add("1");
            onePlusNonFactors.addAll(nonFactors);
            this.dependentComboBox.setModel(new DefaultComboBoxModel(nonFactors));
            this.independentList.setListData(RUtils.colnamesVector(this.getDatasetPane().getSelectedDataset()));
            this.sampleSizeComboBox.setModel(new DefaultComboBoxModel(onePlusNonFactors));
            if (this.dependentComboBox.getItemCount() > 0) {
                this.dependentComboBox.setSelectedIndex(0);
            }
            if (this.sampleSizeComboBox.getItemCount() > 0) {
                this.sampleSizeComboBox.setSelectedIndex(0);
            }
        } else {
            this.dependentComboBox.removeAllItems();
            this.independentList.setModel(new DefaultListModel());
            this.sampleSizeComboBox.removeAllItems();
        }
        this.refreshValidity();
    }

    private void refreshSiteVarList() {
        JComboBox colList = this.getSiteVarList();
        String dataset = this.getDatasetPane().getSelectedDataset();
        if (dataset != null) {
            Vector factors = RUtils.factors(dataset);
            colList.removeAllItems();
            colList.setModel(new DefaultComboBoxModel(factors));
        }
        this.refreshSiteValList();
    }

    private void refreshSiteValList() {
        String dataset = this.getDatasetPane().getSelectedDataset();
        if (dataset != null && this.siteVarList.getItemCount() > 0) {
            String col = (String)this.siteVarList.getSelectedItem();
            String cmd = "unique(" + dataset + "$" + col + ")";
            Vector v = RUtils.evalAsVector(cmd);
            this.siteIDValList.setListData(v);
            this.siteIDValList.setSelectedIndex(0);
        } else {
            Vector v = new Vector(0);
            this.siteIDValList.setListData(v);
        }
        this.refreshValidity();
    }

    public void refreshSubmitButtonValidity() {
        this.getSubmitButton().setEnabled(this.siteVarList.getSelectedIndex() >= 0 && this.siteIDValList.getMaxSelectionIndex() >= 0 && !this.independentList.isSelectionEmpty());
    }

    public void refreshValidity() {
        this.refreshModelValidity();
        this.refreshSubmitButtonValidity();
    }

    private void initComponents() {
        this.distButtonGroup = new ButtonGroup();
        this.plotPane = new JPanel();
        this.distPane = new JPanel();
        this.normDistButton = new JRadioButton();
        this.poisDistButton = new JRadioButton();
        this.binomDistButton = new JRadioButton();
        this.modelEqPane = new JPanel();
        this.modelEqScrollPane = new JScrollPane();
        this.modelEqTextArea = new JTextArea();
        this.varPane = new JPanel();
        this.dependentLabel = new JLabel();
        this.dependentComboBox = new JComboBox();
        this.independentLabel = new JLabel();
        this.independentScrollPane = new JScrollPane();
        this.independentList = new JList();
        this.sampleSizeLabel = new JLabel();
        this.sampleSizeComboBox = new JComboBox();
        this.siteSelPane = new JPanel();
        this.siteVarLabel = new JLabel();
        this.siteVarList = new JComboBox();
        this.siteIDLabel = new JLabel();
        this.siteIDValScrollPane = new JScrollPane();
        this.siteIDValList = new JList();
        this.idPane = new JPanel();
        this.idVarLabel = new JLabel();
        this.idVarList = new JComboBox();
        this.analysisOptionsPane = new JPanel();
        this.sigLabel = new JLabel();
        this.sigLevel = new JSpinner();
        this.rmIntercept = new JCheckBox();
        this.savePanel = new JPanel();
        this.browserResults = new JCheckBox();
        this.distPane.setBorder(BorderFactory.createTitledBorder("Distribution"));
        this.distButtonGroup.add(this.normDistButton);
        this.normDistButton.setSelected(true);
        this.normDistButton.setText("Normal");
        this.normDistButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.normDistButton.setMargin(new Insets(0, 0, 0, 0));
        this.distButtonGroup.add(this.poisDistButton);
        this.poisDistButton.setText("Poisson");
        this.poisDistButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.poisDistButton.setMargin(new Insets(0, 0, 0, 0));
        this.distButtonGroup.add(this.binomDistButton);
        this.binomDistButton.setText("Binomial");
        this.binomDistButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.binomDistButton.setMargin(new Insets(0, 0, 0, 0));
        this.binomDistButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                RegressionPrediction.this.binomDistButtonStateChanged(evt);
            }
        });
        GroupLayout distPaneLayout = new GroupLayout((Container)this.distPane);
        this.distPane.setLayout((LayoutManager)distPaneLayout);
        distPaneLayout.setHorizontalGroup((GroupLayout.Group)distPaneLayout.createParallelGroup(1).add((GroupLayout.Group)distPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.normDistButton).add(18, 18, 18).add((Component)this.poisDistButton).add(18, 18, 18).add((Component)this.binomDistButton).addContainerGap(42, Short.MAX_VALUE)));
        distPaneLayout.setVerticalGroup((GroupLayout.Group)distPaneLayout.createParallelGroup(1).add((GroupLayout.Group)distPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)distPaneLayout.createParallelGroup(3).add((Component)this.normDistButton).add((Component)this.poisDistButton).add((Component)this.binomDistButton)).addContainerGap(17, Short.MAX_VALUE)));
        this.modelEqPane.setBorder(BorderFactory.createTitledBorder("Model Equation"));
        this.modelEqTextArea.setColumns(20);
        this.modelEqTextArea.setEditable(false);
        this.modelEqTextArea.setLineWrap(true);
        this.modelEqTextArea.setRows(2);
        this.modelEqTextArea.setWrapStyleWord(true);
        this.modelEqScrollPane.setViewportView(this.modelEqTextArea);
        GroupLayout modelEqPaneLayout = new GroupLayout((Container)this.modelEqPane);
        this.modelEqPane.setLayout((LayoutManager)modelEqPaneLayout);
        modelEqPaneLayout.setHorizontalGroup((GroupLayout.Group)modelEqPaneLayout.createParallelGroup(1).add(2, (GroupLayout.Group)modelEqPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.modelEqScrollPane, -1, 646, Short.MAX_VALUE).addContainerGap()));
        modelEqPaneLayout.setVerticalGroup((GroupLayout.Group)modelEqPaneLayout.createParallelGroup(1).add((GroupLayout.Group)modelEqPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.modelEqScrollPane, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.varPane.setBorder(BorderFactory.createTitledBorder("Variables"));
        this.dependentLabel.setText("Dependent:");
        this.dependentComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RegressionPrediction.this.dependentComboBoxActionPerformed(evt);
            }
        });
        this.independentLabel.setText("Independent:");
        this.independentList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                RegressionPrediction.this.independentListValueChanged(evt);
            }
        });
        this.independentScrollPane.setViewportView(this.independentList);
        this.sampleSizeLabel.setText("Sample Size:");
        GroupLayout varPaneLayout = new GroupLayout((Container)this.varPane);
        this.varPane.setLayout((LayoutManager)varPaneLayout);
        varPaneLayout.setHorizontalGroup((GroupLayout.Group)varPaneLayout.createParallelGroup(1).add((GroupLayout.Group)varPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)varPaneLayout.createParallelGroup(2).add((Component)this.sampleSizeLabel).add((Component)this.independentLabel).add((Component)this.dependentLabel)).addPreferredGap(0).add((GroupLayout.Group)varPaneLayout.createParallelGroup(1).add((Component)this.independentScrollPane, -1, 233, Short.MAX_VALUE).add(2, (Component)this.sampleSizeComboBox, 0, 233, Short.MAX_VALUE).add(2, (Component)this.dependentComboBox, 0, 233, Short.MAX_VALUE)).addContainerGap()));
        varPaneLayout.setVerticalGroup((GroupLayout.Group)varPaneLayout.createParallelGroup(1).add((GroupLayout.Group)varPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)varPaneLayout.createParallelGroup(3).add((Component)this.dependentComboBox, -2, -1, -2).add((Component)this.dependentLabel)).addPreferredGap(0).add((GroupLayout.Group)varPaneLayout.createParallelGroup(1).add((Component)this.independentLabel).add((Component)this.independentScrollPane, -1, 234, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)varPaneLayout.createParallelGroup(3).add((Component)this.sampleSizeComboBox, -2, -1, -2).add((Component)this.sampleSizeLabel)).addContainerGap()));
        this.siteSelPane.setBorder(BorderFactory.createTitledBorder("Reference Selection"));
        this.siteVarLabel.setText("Reference Variable:");
        this.siteVarList.setPreferredSize(new Dimension(120, 24));
        this.siteVarList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RegressionPrediction.this.siteVarListActionPerformed(evt);
            }
        });
        this.siteIDLabel.setText("Reference Data Values:");
        this.siteIDValList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                RegressionPrediction.this.siteIDValListValueChanged(evt);
            }
        });
        this.siteIDValScrollPane.setViewportView(this.siteIDValList);
        GroupLayout siteSelPaneLayout = new GroupLayout((Container)this.siteSelPane);
        this.siteSelPane.setLayout((LayoutManager)siteSelPaneLayout);
        siteSelPaneLayout.setHorizontalGroup((GroupLayout.Group)siteSelPaneLayout.createParallelGroup(1).add((GroupLayout.Group)siteSelPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)siteSelPaneLayout.createParallelGroup(2).add((Component)this.siteIDLabel).add((Component)this.siteVarLabel)).addPreferredGap(0).add((GroupLayout.Group)siteSelPaneLayout.createParallelGroup(1).add((Component)this.siteIDValScrollPane, -1, 187, Short.MAX_VALUE).add((Component)this.siteVarList, 0, 187, Short.MAX_VALUE)).addContainerGap()));
        siteSelPaneLayout.setVerticalGroup((GroupLayout.Group)siteSelPaneLayout.createParallelGroup(1).add((GroupLayout.Group)siteSelPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)siteSelPaneLayout.createParallelGroup(3).add((Component)this.siteVarLabel).add((Component)this.siteVarList, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)siteSelPaneLayout.createParallelGroup(1).add((Component)this.siteIDLabel).add((Component)this.siteIDValScrollPane, -1, 182, Short.MAX_VALUE)).addContainerGap()));
        this.idPane.setBorder(BorderFactory.createTitledBorder("ID Variable"));
        this.idVarLabel.setText("Variable for Labels:");
        GroupLayout idPaneLayout = new GroupLayout((Container)this.idPane);
        this.idPane.setLayout((LayoutManager)idPaneLayout);
        idPaneLayout.setHorizontalGroup((GroupLayout.Group)idPaneLayout.createParallelGroup(1).add((GroupLayout.Group)idPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.idVarLabel).addPreferredGap(0).add((Component)this.idVarList, 0, 209, Short.MAX_VALUE).addContainerGap()));
        idPaneLayout.setVerticalGroup((GroupLayout.Group)idPaneLayout.createParallelGroup(1).add((GroupLayout.Group)idPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)idPaneLayout.createParallelGroup(3).add((Component)this.idVarLabel).add((Component)this.idVarList, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.analysisOptionsPane.setBorder(BorderFactory.createTitledBorder("Analysis Options"));
        this.sigLabel.setText("Significance Level:");
        this.sigLevel.setModel(new SpinnerNumberModel(0.05, 0.01, 0.5, 0.01));
        this.rmIntercept.setText("Remove Intercept");
        GroupLayout analysisOptionsPaneLayout = new GroupLayout((Container)this.analysisOptionsPane);
        this.analysisOptionsPane.setLayout((LayoutManager)analysisOptionsPaneLayout);
        analysisOptionsPaneLayout.setHorizontalGroup((GroupLayout.Group)analysisOptionsPaneLayout.createParallelGroup(1).add((GroupLayout.Group)analysisOptionsPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.sigLabel).addPreferredGap(0).add((Component)this.sigLevel, -2, -1, -2).add(18, 18, 18).add((Component)this.rmIntercept).addContainerGap(37, Short.MAX_VALUE)));
        analysisOptionsPaneLayout.setVerticalGroup((GroupLayout.Group)analysisOptionsPaneLayout.createParallelGroup(1).add((GroupLayout.Group)analysisOptionsPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)analysisOptionsPaneLayout.createParallelGroup(3).add((Component)this.sigLabel).add((Component)this.sigLevel, -2, -1, -2).add((Component)this.rmIntercept)).addContainerGap(-1, Short.MAX_VALUE)));
        this.savePanel.setBorder(BorderFactory.createTitledBorder("Results"));
        this.browserResults.setText("Display Results in Browser");
        this.browserResults.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.browserResults.setMargin(new Insets(0, 0, 0, 0));
        this.browserResults.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RegressionPrediction.this.browserResultsActionPerformed(evt);
            }
        });
        GroupLayout savePanelLayout = new GroupLayout((Container)this.savePanel);
        this.savePanel.setLayout((LayoutManager)savePanelLayout);
        savePanelLayout.setHorizontalGroup((GroupLayout.Group)savePanelLayout.createParallelGroup(1).add((GroupLayout.Group)savePanelLayout.createSequentialGroup().addContainerGap().add((Component)this.browserResults).addContainerGap(-1, Short.MAX_VALUE)));
        savePanelLayout.setVerticalGroup((GroupLayout.Group)savePanelLayout.createParallelGroup(1).add((GroupLayout.Group)savePanelLayout.createSequentialGroup().add((Component)this.browserResults).addContainerGap(5, Short.MAX_VALUE)));
        GroupLayout plotPaneLayout = new GroupLayout((Container)this.plotPane);
        this.plotPane.setLayout((LayoutManager)plotPaneLayout);
        plotPaneLayout.setHorizontalGroup((GroupLayout.Group)plotPaneLayout.createParallelGroup(1).add((GroupLayout.Group)plotPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)plotPaneLayout.createParallelGroup(1).add((Component)this.modelEqPane, -1, -1, Short.MAX_VALUE).add(2, (GroupLayout.Group)plotPaneLayout.createSequentialGroup().add((GroupLayout.Group)plotPaneLayout.createParallelGroup(1).add((Component)this.varPane, -1, -1, Short.MAX_VALUE).add((Component)this.distPane, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)plotPaneLayout.createParallelGroup(1, false).add((Component)this.analysisOptionsPane, -1, -1, Short.MAX_VALUE).add((Component)this.idPane, -1, -1, Short.MAX_VALUE).add((Component)this.siteSelPane, -1, -1, Short.MAX_VALUE))).add((Component)this.savePanel, -2, -1, -2)).addContainerGap()));
        plotPaneLayout.setVerticalGroup((GroupLayout.Group)plotPaneLayout.createParallelGroup(1).add((GroupLayout.Group)plotPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.modelEqPane, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)plotPaneLayout.createParallelGroup(1, false).add((GroupLayout.Group)plotPaneLayout.createSequentialGroup().add((Component)this.siteSelPane, -2, -1, -2).addPreferredGap(0).add((Component)this.idPane, -2, -1, -2).addPreferredGap(0).add((Component)this.analysisOptionsPane, -2, -1, -2)).add((GroupLayout.Group)plotPaneLayout.createSequentialGroup().add((Component)this.distPane, -2, -1, -2).addPreferredGap(0).add((Component)this.varPane, -1, -1, Short.MAX_VALUE))).addPreferredGap(0).add((Component)this.savePanel, -2, 47, -2).addContainerGap(81, Short.MAX_VALUE)));
        this.setTitle("Regression Prediction");
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 743) / 2, (screenSize.height - 736) / 2, 743, 736);
    }

    private void siteIDValListValueChanged(ListSelectionEvent evt) {
        this.refreshValidity();
    }

    private void siteVarListActionPerformed(ActionEvent evt) {
        this.refreshSiteValList();
    }

    private void binomDistButtonStateChanged(ChangeEvent evt) {
        this.sampleSizeLabel.setEnabled(this.binomDistButton.isSelected());
        this.sampleSizeComboBox.setEnabled(this.binomDistButton.isSelected());
        this.updateModelEquation();
    }

    private void dependentComboBoxActionPerformed(ActionEvent evt) {
        this.updateModelEquation();
    }

    private void independentListValueChanged(ListSelectionEvent evt) {
        this.updateModelEquation();
        this.refreshSubmitButtonValidity();
    }

    private void browserResultsActionPerformed(ActionEvent evt) {
    }

    public JComboBox getIdVarList() {
        return this.idVarList;
    }

    public JComboBox getSiteVarList() {
        return this.siteVarList;
    }

    public Object[] getSiteValListSelectedValues() {
        return GUIUtils.getSelectedValues(this.siteIDValList);
    }

    private void refreshIdVarList() {
        JComboBox colList = this.getIdVarList();
        int m = colList.getItemCount();
        for (int k = 1; k < m; ++k) {
            colList.removeItemAt(1);
        }
        String dataset = this.getDatasetPane().getSelectedDataset();
        if (dataset != null) {
            String[] colnames = RUtils.colnames(dataset);
            int colLength = colnames.length;
            for (int k = 0; k < colLength; ++k) {
                colList.insertItemAt(colnames[k], k + 1);
            }
            colList.setSelectedIndex(0);
        }
    }

    protected void submitButtonAction() {
        String distfamily = null;
        if (this.normDistButton.isSelected()) {
            distfamily = "gaussian";
        } else if (this.poisDistButton.isSelected()) {
            distfamily = "poisson";
        } else if (this.binomDistButton.isSelected()) {
            distfamily = "binomial";
        }
        String cmd = "glm.pred.JGR(my.data=" + this.getDatasetPane().getSelectedDataset() + ", subset1.name=" + (RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'").length() == 0 ? "NULL" : "'" + this.getFactorSelectionPane1().getSelectedFactor() + "'") + ", subset1.val=" + (RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'").length() == 0 ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'") + ")") + ", subset2.name=" + (RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'").length() == 0 ? "NULL" : "'" + this.getFactorSelectionPane2().getSelectedFactor() + "'") + ", subset2.val=" + (RUtils.toString(this.getFactorSelectionPane2().getSelectedFactorValues(), ",", "'").length() == 0 ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane2().getSelectedFactorValues(), ",", "'") + ")") + ", site.name=" + "'" + this.getSiteVarList().getSelectedItem().toString() + "'" + ", site.val=" + "c(" + RUtils.toString(this.getSiteValListSelectedValues(), ",", "'") + ")" + ", my.formula=" + "'" + this.getModelString() + "'" + ", my.family=" + "'" + distfamily + "'" + ", label.name=" + "'" + this.idVarList.getSelectedItem() + "'" + ", sig.level=" + (Double)this.sigLevel.getValue() + ", iRmIntercept=" + String.valueOf(this.rmIntercept.isSelected()).toUpperCase() + ", browserResults=" + String.valueOf(this.browserResults.isSelected()).toUpperCase() + ")";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    protected void helpButtonAction() {
        String cmd = "CADStat.help('glm.pred.JGR')";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    public String getModelString() {
        return this.modelString;
    }

    public void setModelString(String modelString) {
        this.modelString = modelString;
    }
}

