% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{GPC_cpp}
\alias{GPC_cpp}
\alias{GPC2_cpp}
\title{C++ function performing the pairwise comparison over several endpoints.}
\usage{
GPC_cpp(
  endpoint,
  status,
  indexC,
  posC,
  indexT,
  posT,
  threshold,
  weight,
  method,
  op,
  D,
  D_UTTE,
  n_strata,
  nUTTE_analyzedPeron_M1,
  index_endpoint,
  index_status,
  index_UTTE,
  list_survTimeC,
  list_survTimeT,
  list_survJumpC,
  list_survJumpT,
  list_lastSurv,
  p_C,
  p_T,
  iid_survJumpC,
  iid_survJumpT,
  zeroPlus,
  correctionUninf,
  hierarchical,
  hprojection,
  neutralAsUninf,
  addHalfNeutral,
  keepScore,
  precompute,
  returnIID,
  debug
)

GPC2_cpp(
  endpoint,
  status,
  indexC,
  posC,
  indexT,
  posT,
  threshold,
  weight,
  method,
  op,
  D,
  D_UTTE,
  n_strata,
  nUTTE_analyzedPeron_M1,
  index_endpoint,
  index_status,
  index_UTTE,
  list_survTimeC,
  list_survTimeT,
  list_survJumpC,
  list_survJumpT,
  list_lastSurv,
  p_C,
  p_T,
  iid_survJumpC,
  iid_survJumpT,
  zeroPlus,
  correctionUninf,
  hierarchical,
  hprojection,
  neutralAsUninf,
  addHalfNeutral,
  keepScore,
  precompute,
  returnIID,
  debug
)
}
\arguments{
\item{endpoint}{A matrix containing the values of each endpoint (in columns) for each observation (in rows).}

\item{status}{A matrix containing the values of the status variables relative to each endpoint (in columns) for each observation (in rows).}

\item{indexC}{A list containing, for each strata, which rows of the endpoint and status matrices corresponds to the control observations. Not unique when bootstraping.}

\item{posC}{A list containing, for each strata, the unique identifier of each control observations.}

\item{indexT}{A list containing, for each strata, which rows of the endpoint and status matrices corresponds to the treatment observations. Not unique when bootstraping.}

\item{posT}{A list containing, for each strata, the unique identifier of each treatment observations.}

\item{threshold}{Store the thresholds associated to each endpoint. Must have length D. The threshold is ignored for binary endpoints.}

\item{weight}{Store the weight associated to each endpoint. Must have length D.}

\item{method}{The index of the method used to score the pairs. Must have length D. 1 for binary/continuous, 2 for Gaussian, 3/4 for Gehan (left or right-censoring), and 5/6 for Peron (right-censoring survival or competing risks).}

\item{op}{The index of the operator used to score the pairs. Must have length D. 1 for larger is beter, -1 for smaller is better.}

\item{D}{The number of endpoints.}

\item{D_UTTE}{The number of distinct time to event endpoints.}

\item{n_strata}{The number of strata.}

\item{nUTTE_analyzedPeron_M1}{The number of unique time-to-event endpoints that have been analyzed the Peron scoring rule before the current endpoint. Must have length D.}

\item{index_endpoint}{The position of the endpoint at each priority in the argument endpoint. Must have length D.}

\item{index_status}{The position of the status at each priority in the argument status. Must have length D.}

\item{index_UTTE}{The position, among all the unique tte endpoints, of the TTE endpoints. Equals -1 for non tte endpoints. Must have length n_TTE.}

\item{list_survTimeC}{A list of matrix containing the survival estimates (-threshold, 0, +threshold ...) for each event of the control group (in rows).}

\item{list_survTimeT}{A list of matrix containing the survival estimates (-threshold, 0, +threshold ...) for each event of the treatment group (in rows).}

\item{list_survJumpC}{A list of matrix containing the survival estimates and survival jumps when the survival for the control arm jumps.}

\item{list_survJumpT}{A list of matrix containing the survival estimates and survival jumps when the survival for the treatment arm jumps.}

\item{list_lastSurv}{A list of matrix containing the last survival estimate in each strata (rows) and treatment group (columns).}

\item{p_C}{Number of nuisance parameter in the survival model for the control group, for each endpoint and strata}

\item{p_T}{Number of nuisance parameter in the survival model for the treatment group, for each endpoint and strata}

\item{iid_survJumpC}{A list of matrix containing the iid of the survival estimates in the control group.}

\item{iid_survJumpT}{A list of matrix containing the iid of the survival estimates in the treatment group.}

\item{zeroPlus}{Value under which doubles are considered 0?}

\item{correctionUninf}{Should the uninformative weight be re-distributed to favorable and unfavorable?}

\item{hierarchical}{Should only the uninformative pairs be analyzed at the lower priority endpoints (hierarchical GPC)? Otherwise all pairs will be compaired for all endpoint (full GPC).}

\item{hprojection}{Order of the H-projection used to compute the variance.}

\item{neutralAsUninf}{Should paired classified as neutral be re-analyzed using endpoints of lower priority?}

\item{addHalfNeutral}{Should half of the neutral score be added to the favorable and unfavorable scores?}

\item{keepScore}{Should the result of each pairwise comparison be kept?}

\item{precompute}{Have the integrals relative to the survival be already computed and stored in list_survTimeC/list_survTimeT and list_survJumpC/list_survJumpT (derivatives)}

\item{returnIID}{Should the iid be computed?}

\item{debug}{Print messages tracing the execution of the function to help debugging. The amount of messages increase with the value of debug (0-5).}
}
\description{
\code{GPC_cpp} call for each endpoint and each strata the pairwise comparison function suited to the type of endpoint and store the results.
}
\details{
GPC_cpp implements GPC looping first over endpoints and then over pairs.
To handle multiple endpoints, it stores some of the results which can be memory demanding when considering large sample - especially when computing the iid decomposition.
GPC2_cpp implements GPC looping first over pairs and then over endpoints. It has rather minimal memory requirement but does not handle correction for uninformative pairs.
}
\author{
Brice Ozenne
}
\keyword{BuyseTest}
\keyword{Cpp}
\keyword{function}
