% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BuyseRes-summary.R
\docType{methods}
\name{BuyseRes-summary}
\alias{BuyseRes-summary}
\alias{summary,BuyseRes-method}
\title{Summary Method for Class "BuyseRes"}
\usage{
\S4method{summary}{BuyseRes}(object, print = TRUE, percentage = TRUE,
  statistic = NULL, conf.level = NULL, strata = if
  (length(object@level.strata) == 1) {     "global" } else {     NULL },
  digit = c(2, 4), ...)
}
\arguments{
\item{object}{output of \code{\link{BuyseTest}}}

\item{print}{[logical] Should the table be displayed?.}

\item{percentage}{[logical] Should the percentage of pairs of each type be displayed ? Otherwise the number of pairs is displayed.}

\item{statistic}{[character] the statistic summarizing the pairwise comparison:
\code{"netBenefit"} displays the net benefit, as described in Buyse (2010) and Peron et al. (2016)),
whereas \code{"winRatio"} displays the win ratio, as described in Wang et al. (2016).
Default value read from \code{BuyseTest.options()}.}

\item{conf.level}{[numeric] confidence level for the confidence intervals.
Default value read from \code{BuyseTest.options()}.}

\item{strata}{[character vector] the name of the strata to be displayed. Can also be \code{"global"} to display the average over all strata.}

\item{digit}{[integer vector] the number of digit to use for printing the counts and the delta.}

\item{...}{arguments to be passed to \code{confint}}
}
\description{
Summarize the results from the \code{\link{BuyseTest}} function.
}
\details{
When using a permutation test, the uncertainty associated with the estimator is computed under the null hypothesis.
Thus the confidence interval may not be valid if the null hypothesis is false. \cr
More precisely, the quantiles of the distribution of the statistic are computed under the null hypothesis and then shifted by the point estimate of the statistic.
Therefore it is possible that the limits of the confidence interval
are estimated outside of the interval of definition of the statistic (e.g. outside [-1,1] for the proportion in favor of treatment). \cr \cr

Note: For the win ratio, the proposed implementation enables the use of thresholds and endpoints that are not time to events
as well as the correction proposed in Peron et al. (2016) to account for censoring. 
These development have not been examined by Wang et al. (2016), or in other papers (at out knowledge).
They are only provided here by implementation convenience.
}
\examples{
dt <- simBuyseTest(1e2, n.strata = 3)

 \dontrun{
 BT <- BuyseTest(Treatment ~ TTE(eventtime, censoring = status) + Bin(toxicity), data=dt)
 }
 \dontshow{
 BT <- BuyseTest(Treatment ~ TTE(eventtime, censoring = status) + Bin(toxicity), data=dt, n.resampling = 10, trace = 0)
 }
 summary(BT)
 summary(BT, percentage = FALSE)
 summary(BT, statistic = "winRatio")

}
\seealso{
\code{\link{BuyseTest}} for performing a generalized pairwise comparison. \cr
  \code{\link{BuyseRes-class}} for a presentation of the \code{BuyseRes} object.
}
\keyword{BuyseRes-method}
\keyword{summary}
