% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BuddleMain.R
\name{Split2TrainTest}
\alias{Split2TrainTest}
\title{Splitting Data into Training and Test Sets.}
\usage{
Split2TrainTest(Y, X, train.ratio)
}
\arguments{
\item{Y}{an n-by-1 vector of responses or labels.}

\item{X}{an n-by-p design matrix of predictors.}

\item{train.ratio}{a ratio of the size of the resulting training set to the size of data.}
}
\value{
A list of the following values:
\describe{

\item{y.train}{the training set of Y.}
\item{y.test}{the test set of Y.}
\item{x.train}{the training set of X.}
\item{x.test}{the test set of X.}

}
}
\description{
Convert data into training and test sets so that the training set contains approximately the specified ratio of all labels.
}
\examples{

data(iris)

train.ratio=0.8
Y = iris$Species 
X = cbind( iris$Sepal.Length, iris$Sepal.Width, iris$Petal.Length, iris$Petal.Width)

lst = Split2TrainTest(Y, X, train.ratio)


}
\seealso{
CheckNonNumeric(), GetPrecision(), FetchBuddle(), MakeConfusionMatrix(), OneHot2Label(), TrainBuddle()
}
