% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BP_OpenImage.R
\name{BP_OpenImage}
\alias{BP_OpenImage}
\title{Open an image}
\usage{
BP_OpenImage(file = file.choose(), name = NULL, ijtiff = FALSE)
}
\arguments{
\item{file}{The file to be opened}

\item{name}{Name of this slice}

\item{ijtiff}{Should the ijtiff must be used to read tiff image}
}
\value{
Characteristics of an image
}
\description{
Open an image.
}
\details{
BP_OpenImage opens an image
}
\examples{
\dontrun{
# Not run:
library(BoneProfileR)
path_Hedgehog <- system.file("extdata", "Erinaceus_europaeus_fem_2-1_small.png", 
                             package = "BoneProfileR")
 bone <- BP_OpenImage(file=path_Hedgehog)
 plot(bone)
 path_Hedgehog <- system.file("extdata", "Erinaceus_europaeus_fem_2-1_small.tif", 
                             package = "BoneProfileR")
 bone <- BP_OpenImage(file=path_Hedgehog)
 plot(bone)
 bone <- BP_OpenImage(file=path_Hedgehog, ijtiff=TRUE)
 plot(bone)
 # A partial section
 path_Dicynodon <- system.file("extdata", "Dicynodon_tibia_11.11.1.T_b_b-1.png", 
                             package = "BoneProfileR")
 bone <- BP_OpenImage(file=path_Dicynodon)
 plot(bone)
 # To open a file with a dialog:
 bone <- BP_OpenImage()
}
}
\seealso{
Other BoneProfileR: 
\code{\link{BP_AutoFit}()},
\code{\link{BP_ChooseBackground}()},
\code{\link{BP_ChooseCenter}()},
\code{\link{BP_ChooseForeground}()},
\code{\link{BP_DetectBackground}()},
\code{\link{BP_DetectCenters}()},
\code{\link{BP_DetectForeground}()},
\code{\link{BP_DuplicateAnalysis}()},
\code{\link{BP_EstimateCompactness}()},
\code{\link{BP_FitBayesianCompactness}()},
\code{\link{BP_FitMLCompactness}()},
\code{\link{BP_FitMLRadialCompactness}()},
\code{\link{BP_GetFittedParameters}()},
\code{\link{BP_ListAnalyses}()},
\code{\link{BP_LnLCompactness}()},
\code{\link{BP_Report}()},
\code{\link{Erinaceus_europaeus}},
\code{\link{plot.BoneProfileR}()},
\code{\link{summary.BoneProfileR}()}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
\concept{BoneProfileR}
