% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{get_subgroup_results}
\alias{get_subgroup_results}
\title{Get Subgroup Results}
\usage{
get_subgroup_results(model, X_feature, subgroup_label = NULL, cutoff = 0.5)
}
\arguments{
\item{model}{The trained XGBoost-based subgroup model.}

\item{X_feature}{The data matrix containing patient features.}

\item{subgroup_label}{(Optional) The subgroup labels. In real-world data, this information is typically unknown and only available in simulated data. If provided, the prediction accuracy will also be returned.}

\item{cutoff}{The cutoff value for treatment assignment, defaulted to 0.5.}
}
\value{
A data frame containing each subject and assigned treatment (1 for treatment, 0 for control). If subgroup labels are provided, it also returns the prediction accuracy of the subgroup labels.
}
\description{
This function predicts the treatment assignment for each patient based on a cutoff value.
}
