% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/508-extractProtCTDT.R
\name{extrProtCTDT}
\alias{extrProtCTDT}
\title{CTD Descriptors - Transition}
\usage{
extrProtCTDT(x)
}
\arguments{
\item{x}{A character vector, as the input protein sequence.}
}
\value{
A length 21 named vector
}
\description{
CTD Descriptors - Transition
}
\details{
This function calculates the Transition descriptor of the 
CTD descriptors (Dim: 21).
}
\examples{
x = readFASTA(system.file('protseq/P00750.fasta', package = 'BioMedR'))[[1]]
extrProtCTDT(x)

}
\references{
Inna Dubchak, Ilya Muchink, Stephen R. Holbrook and Sung-Hou Kim. 
Prediction of protein folding class using global description of 
amino acid sequence. \emph{Proceedings of the National Academy of Sciences}. 
USA, 1995, 92, 8700-8704.

Inna Dubchak, Ilya Muchink, Christopher Mayor, Igor Dralyuk and Sung-Hou Kim.
Recognition of a Protein Fold in the Context of the SCOP classification. 
\emph{Proteins: Structure, Function and Genetics}, 1999, 35, 401-407.
}
\seealso{
See \code{\link{extrProtCTDC}} and \code{\link{extrProtCTDD}} 
         for Composition and Distribution of the CTD descriptors.
}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>, 
        Nan Xiao <\url{http://r2s.name}>
}
\keyword{CTD}
\keyword{CTDT}
\keyword{Transition}
\keyword{extrProtCTDT}
\keyword{extract}
