% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/479-extractDrugShortestPath.R
\name{extrDrugShortestPathComplete}
\alias{extrDrugShortestPathComplete}
\title{Calculate the Shortest Path Molecular Fingerprints (in Complete Format)}
\usage{
extrDrugShortestPathComplete(molecules, depth = 6, size = 1024,
  silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{depth}{The search depth. Default is \code{6}.}

\item{size}{The length of the fingerprint bit string. Default is \code{1024}.}

\item{silent}{Logical. Whether the calculating process 
should be shown or not, default is \code{TRUE}.}
}
\value{
An integer vector or a matrix. Each row represents one molecule, 
the columns represent the fingerprints.
}
\description{
Calculate the Shortest Path Molecular Fingerprints (in Complete Format)
}
\details{
Calculate the fingerprint based on the shortest paths between pairs 
of atoms and takes into account ring systems, charges etc.
}
\examples{
\donttest{
smi = system.file('vignettedata/test.smi', package = 'BioMedR')
mol = readMolFromSmi(smi, type = 'mol')
fp  = extrDrugShortestPathComplete(mol)
dim(fp)}

}
\seealso{
\link{extrDrugShortestPath}
}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>, 
        Nan Xiao <\url{http://r2s.name}>
}
\keyword{extrDrugShortestPathComplete}
